<?php
session_start();
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
   header("location: home.php");
   exit;
}

require_once "modelo/conexion.php";
$username = $password = "";
$username_err = $password_err = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") {
   if (empty(trim($_POST["username"]))) {
      $username_err = "Por favor ingrese su usuario.";
   } else {
      $username = trim($_POST["username"]);
   }
   if (empty(trim($_POST["password"]))) {
      $password_err = "Por favor ingrese su contraseña.";
   } else {
      $password = trim($_POST["password"]);
   }
   if (empty($username_err) && empty($password_err)) {
      $sql = "SELECT e.lEstudiante_id id, e.sEmail username, e.sPassword password, concat(e.sApellido,' ',e.sNombre) fullname, r.lRegistro_id  FROM tblestudiantes e, tblregistros r WHERE e.lEstudiante_id = r.lEstudiante_id and e.lGestionActual_id = r.lGestion_id and sEmail = ?";

      if ($stmt = mysqli_prepare($link, $sql)) {
         mysqli_stmt_bind_param($stmt, "s", $param_username);
         $param_username = $username;
         if (mysqli_stmt_execute($stmt)) {
            mysqli_stmt_store_result($stmt);
            if (mysqli_stmt_num_rows($stmt) == 1) {
               mysqli_stmt_bind_result($stmt, $id, $username, $hashed_password, $fullname, $lRegistro_id);
               if (mysqli_stmt_fetch($stmt)) {
                  if (MD5($password) === $hashed_password) {
                     session_start();
                     $_SESSION["loggedin"] = true;
                     $_SESSION["id"] = $id;
                     $_SESSION["username"] = $fullname;
                     $_SESSION["lRegistro_id"] = $lRegistro_id;
                     header("location: home.php");
                  } else {
                     $password_err = "La contraseña que has ingresado no es válida.";
                  }
               }
            } else {
               $username_err = "No existe cuenta registrada con ese nombre de usuario.";
            }
         } else {
            echo "Algo salió mal, por favor vuelve a intentarlo.";
         }
      }
      mysqli_stmt_close($stmt);
   }
   mysqli_close($link);
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

   <link rel="stylesheet" href="css/bootstrap.css">
   <link rel="stylesheet" type="text/css" href="css/style.css">
   <title>Login</title>
   <link rel="shortcut icon" href="img/logo.jpeg">
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KyZXEAg3QhqLMpG8r+8fhAXLRk2vvoC2f3B09zVXn8CA5QIVfZOJ3BCsw2P0p/We" crossorigin="anonymous">
   <link rel="stylesheet" href="css/login.css" />
   <link rel="stylesheet" href="css/style02.css" />

</head>

<body>
   <div class="loginscreen background-general" ng-controller="AuthCtrl" ng-cloak ng-init="setRecaptcha()">
      <div id="container-login">
         <div class="circle-white"></div>
         <div class="container-login-internal animated fadeInDown">
            <div class="login">
               <div class="margin-login-mobile text-center">
                  <img class="img-responsive m-auto" src="img/logo01.jpg" alt="" width="140px" height="160px" />
                  <h3 style="margin-bottom: 5px;"><strong>Ingresa a tu cuenta</strong></h3>
                  <p>Podrás ver detalles de los aportes realizados</p>

               </div>
               <div class="login-content">
                  <form name="formlogin" class="form-signin m-t" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
                     <h2 class="title">BIENVENIDO</h2>
                     <div class="input-div one form-floating">
                        <div class="i">
                           <i class="fas fa-user"></i>
                        </div>
                        <div class="div">
                           <h5>e-mail institucional</h5>
                           <input id="username" type="email" class="input" name="username" required>
                        </div>
                     </div>

                     <div class="input-div pass form-floating">
                        <div class="i">
                           <i class="fas fa-lock"></i>
                        </div>
                        <div class="div">
                           <h5>Contraseña</h5>
                           <input type="password" class="input" name="password" id="password" required />
                        </div>
                     </div>
                     <div class="view">
                        <div class="fas fa-eye verPassword" onclick="vista()" id="verPassword"></div>
                     </div>
                     <button class="w-100 btn btn-lg btn-primary btn color-btn-login block full-width m-b" type="submit">Ingresar</button>
                  </form>
               </div>
            </div>
            <div class="animation-icon">
               <div class="text-hide-mobile text-center">
                  <h2 style="font-size: 160%">Cambia tus pensamientos </h2>
                  <h2 style="margin-bottom: 4rem !important; font-size: 160%">y cambiarás tu mundo</h2>
               </div>
               <div id="carousel-content">
                  <div id="carousel-box" style="text-align: left;">
                     <div>
                        <li id="animation-delay-1" class="icon-delay" style="font-size: 120%"><img src="img/check.png" width="40" alt="">Siempre se puede ser mejor.</li>
                     </div>
                     <div class="carousel-item1">
                        <li id="animation-delay-2" class="icon-delay" style="font-size: 120%"><img src="img/check.png" width="40" alt="">El éxito depende del esfuerzo.</li>
                     </div>
                     <div class="carousel-item1">
                        <li id="animation-delay-3" class="icon-delay" style="font-size: 120%"><img src="img/check.png" width="40" alt="">Haz de cada día una obra maestra.</li>
                     </div>
                     <div class="carousel-item1">
                        <li id="animation-delay-4" class="icon-delay" style="font-size: 120%"><img src="img/check.png" width="40" alt="">El precio del éxito es el trabajo duro.
                        </li>
                     </div>
                  </div>
               </div>
            </div>
            <footer>2024. (SysBest.IT) Todos los derechos reservados ©</footer>
         </div>
      </div>
   </div>


   <script src="js/fontawesome.js"></script>
   <script src="js/main.js"></script>
   <script src="js/main2.js"></script>
   <script src="js/jquery.min.js"></script>
   <script src="js/bootstrap.js"></script>
   <script src="js/bootstrap.bundle.js"></script>



</body>

</html>