<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
   header("location: index.php");
   exit;
}

require_once "modelo/conexion.php";

if (isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] == true){
   $sql ="call pPlanpagos(0,null,null,null,null,null,?,null,null,6)";

   if($stmt = mysqli_prepare($link, $sql)){       
       mysqli_stmt_bind_param($stmt, "i", $_SESSION["lRegistro_id"]);
       if(mysqli_stmt_execute($stmt)){
           mysqli_stmt_store_result($stmt);
           if(mysqli_stmt_num_rows($stmt) == 1){                    
               mysqli_stmt_bind_result($stmt, $lRegistro_id, $sGestion, $sDescripcion, $sEstudiante, $lMonto, $lDeuda, $lPagado, $pp);                              
               mysqli_stmt_fetch($stmt);               
           } else{
               $username_err = "No existe cuenta registrada con ese nro. de registro";
           }
       } else{
           echo "Algo salió mal, por favor vuelve a intentarlo.";
       }
   }
   mysqli_stmt_close($stmt);
   mysqli_close($link);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
   <meta charset="UTF-8">
   <title>Pagos</title>
   <link rel="shortcut icon" href="img/logo.jpeg">
   <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.css">
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KyZXEAg3QhqLMpG8r+8fhAXLRk2vvoC2f3B09zVXn8CA5QIVfZOJ3BCsw2P0p/We" crossorigin="anonymous">
   <style type="text/css">
      body {
         font: 14px sans-serif;
         text-align: center;
         background: linear-gradient(90deg, #eff0f1 0%, #e9edee 100%);
      }
   </style>
</head>

<body>
   <div class="page-header">
      <h1>Hola, <b><?php echo htmlspecialchars($_SESSION["username"]); ?></b>. Bienvenid@.</h1>
      <hr>
   </div>

   <div class="col-xs-4 col-sm-4 col-md-4">
      <div class="form-group">
         <strong>Estudiante:</strong>
         <?php echo $sEstudiante ?>
         
      </div>
   </div>
   <div class="col-xs-4 col-sm-4 col-md-4">
      <div class="form-group">
         <strong>Gestión:</strong>
         <?php echo $sGestion ?>
      </div>
   </div>
   <div class="col-xs-4 col-sm-4 col-md-4">
      <div class="form-group">
         <strong>Unidad Educativa:</strong>
         <?php echo $sDescripcion ?>
      </div>
   </div>
   <div class="col-xs-4 col-sm-4 col-md-4">
      <div class="form-group">
         <strong>Monto:</strong>
         <?php echo $lMonto ?>
      </div>
   </div>
   <div class="col-xs-4 col-sm-4 col-md-4">
      <div class="form-group">
         <strong>Deuda:</strong>
         <?php echo $lDeuda ?>
      </div>
   </div>
   <div class="col-xs-4 col-sm-4 col-md-4">
      <div class="form-group">
         <strong>Pagado:</strong>
         <?php echo $lPagado ?>
      </div>
   </div>  

   <div class="col-xs-12 col-sm-12 col-md-12">
      <div class="form-group">
         <div class="container text-center">
            <div class="row border border-primary">
               <div class="col-1 col-sm-1 text-danger border-bottom border-danger">.</div>
               <div class="col-2 col-sm-2 text-danger border-bottom border-danger"><strong>Cuota</strong></div>
               <!--<div class="col-2 col-sm-2 text-danger border-bottom border-danger"><strong>Monto</strong></div>-->
               <div class="col-2 col-sm-2 text-danger border-bottom border-danger"><strong>Mes</strong></div>
               <div class="col-2 col-sm-2 text-danger border-bottom border-danger"><strong>Estado</strong></div>
               <div class="col-2 col-sm-2 text-danger border-bottom border-danger"><strong>Saldo</strong></div>
               <div class="col-2 col-sm-2 text-danger border-bottom border-danger"><strong>Fech. Pagado</strong></div>
               <div class="col-1 col-sm-1 text-danger border-bottom border-danger">.</div>
                             

               <?php foreach (json_decode($pp) as $cuotas ) {?>
                <tr>
                    <div class="col-1 col-sm-1"><?php echo ''; ?></div>
                    <div class="col-2 col-sm-2"><?php echo $cuotas->lNroCuota; ?></div>                    
                    <div class="col-2 col-sm-2"><?php echo $cuotas->dtVencimiento; ?></div>
                    <div class="col-2 col-sm-2"><?php echo $cuotas->sEstado; ?></div>
                    <div class="col-2 col-sm-2"><?php echo $cuotas->lSaldo; ?></div>
                    <div class="col-2 col-sm-2"><?php echo $cuotas->lEstado==1? date("d/m/Y", strtotime($cuotas->dtPagado)):'---'; ?></div>
                    <div class="col-1 col-sm-1"><?php echo ''; ?></div>
                </tr>
                <?php } ?>
            </div>
         </div>
      </div>
   </div>
   <p>      
      <a href="logout.php" class="btn btn-lg btn-primary btn color-btn-login block full-width m-b">Cierra la sesión</a>      
   </p>
<hr>
</body>

</html>