


<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Estudiantes</h1>
<hr>
<!-- Mostrar la lista de estudiantes aquí -->
<div class="row">
    <div class="col-lg-6 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('estudiantes.create')); ?>"> Nuevo Estudiante</a>
        </div>
    </div>
    <div class="col margin-tb">
        <div class="d-md-flex justify-content-md-end">
            <form action="<?php echo e(route('estudiantes.index')); ?>" method="GET">
                <div class="btn-group">
                    <input type="text" name="flBuscar" class="form-control" placeholder="Valor a buscar">
                    <input type="submit" value="Filtrar" class="btn btn-primary">
                </div>
            </form>
        </div>
    </div> 
</div>
<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>
<?php endif; ?>
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">Nro.</th>
                <th width="80px">CI</th>
                <th width="80px">Estudiante</th>
                <th width="80px">Unidad Educativa</th>
                <th width="80px">e-mail</th>
                <th width="80px">Estado</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        <?php $__currentLoopData = $estudiantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estudiante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tbody>
            <tr>
                <td><?php echo e($estudiante->lEstudiante_id); ?></td>
                <td><?php echo e($estudiante->sRude); ?></td>
                <td><?php echo e($estudiante->sEstudiante); ?></td>
                <td><?php echo e($estudiante->sUnidad); ?></td>
                <td><?php echo e($estudiante->sEmail); ?></td>

                <td><?php if ($estudiante->boolEstado == 1) : ?>
                        <strong>Activo</strong>
                    <?php else : ?>
                        <strong>No ACTIVO!!</strong>
                    <?php endif ?>
                </td>
                <td>
                    <?php if ($estudiante->boolEstado == 1) : ?>
                        <form action="<?php echo e(route('estudiantes.destroy',$estudiante->lEstudiante_id)); ?>" method="POST">
                            <a class="btn btn-info" href="<?php echo e(route('estudiantes.show',encrypt($estudiante->lEstudiante_id))); ?>">Show</a>
                            <a class="btn btn-primary" href="<?php echo e(route('estudiantes.edit', encrypt($estudiante->lEstudiante_id))); ?>">Editar</a>
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger">Cerrar</button>
                        </form>
                    <?php else : ?>
                        <strong>No activo!!</strong>
                    <?php endif; ?>
                    <?php if ($estudiante->boolEstado == 0) : ?>
                        <a class="btn btn-success" href="<?php echo e(route('registros.create',encrypt($estudiante->lEstudiante_id))); ?>">Inscribir</a>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table> <hr>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmfyacom/pagos.jmfya.com/resources/views/estudiantes/index.blade.php ENDPATH**/ ?>