<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Transacciones</h1>
<hr>

<!-- Mostrar la lista de transacciones aquí -->
<div class="row">
    <div class="col margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('transacciones.create')); ?>"> Nueva transacción</a>
        </div>
    </div>
    <div class="col margin-tb">
        <div class="d-md-flex justify-content-md-end">
            <form action="<?php echo e(route('transacciones.index')); ?>" method="GET">
                <div class="btn-group">
                    <input type="number" min="1" name="flNroTransaccion" class="form-control" placeholder="Nro de transacción">
                    <input type="submit" value="Filtrar" class="btn btn-primary">
                </div>
            </form>
        </div>
    </div>
</div>
<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>
<?php endif; ?>
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">ID</th>
                <th width="80px">Nro. Trans.</th>
                <th width="80px">Fecha</th>
                <th width="80px">Tipo</th>
                <th width="80px">Cliente</th>
                <th width="80px">Total</th>
                <th width="80px">Estado</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        <?php $__currentLoopData = $transacciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tbody>
            <tr>
                <td><?php echo e($transaccion->lTransaccion_id); ?></td>
                <td><?php echo e($transaccion->lNroTransaccion); ?></td>
                <td><?php echo e(date("d/m/Y", strtotime($transaccion->dtTransaccion))); ?></td>
                <td><?php echo e($transaccion->sTipo); ?></td>
                <td><?php echo e($transaccion->sCliente); ?></td>
                <td><?php echo e($transaccion->lTotal); ?></td>
                <td><?php echo e($transaccion->sEstado); ?></td>

                <td>
                    <?php if ($transaccion->lEstado == 1) : ?>
                        <form id="anularForm" action="<?php echo e(route('transacciones.destroy', $transaccion->lTransaccion_id)); ?>" method="POST">
                            <a class="btn btn-info" href="<?php echo e(route('transacciones.show', encrypt($transaccion->lTransaccion_id))); ?>">Show</a>
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="button" id="confirmAnular" class="btn btn-danger">Anular</button>
                        </form>
                    <?php else : ?>
                        <strong>Anulado!!</strong>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
</div>
<script>
    document.getElementById('confirmAnular').addEventListener('click', function() {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¿Quiere anular esta transacción?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sí, anular',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('anularForm').submit();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmfyacom/pagos.jmfya.com/resources/views/transacciones/index.blade.php ENDPATH**/ ?>