<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/reporte.css')); ?>" type="text/css">
    <style>
               
    </style>
</head>

<body>

    <div id="header">
        <img class="imgHeader" src="<?php echo e(public_path('/img/unegocio/')); ?><?php echo e($unegocios[0]->sLogo); ?>" alt="Logo">
        <div class="header2">Unidad educativa: <?php echo e($unegocios[0]->sDescripcion); ?> </div>
        <div class="header2">Turno:<?php echo e($unegocios[0]->sTurno); ?> </div>
        <div class="header2">Fono: <?php echo e($unegocios[0]->sFono); ?> </div>
    </div>

    <hr>
    <div>
        <table>
            <tr>
                <td></td>
                <td class="text-right">
                    <div class="rounded"><strong>Nro. Transacción:</strong> <?php echo e($transacciones[0]->lNroTransaccion); ?></div>
                </td>
            </tr>
            <tr>
                <td><strong>Comprobante de:</strong> <?php echo e($transacciones[0]->sTipo); ?></td>
                <td class="text-right"><strong>Fecha:</strong> <?php echo e(date("d/m/Y", strtotime($transacciones[0]->dtTransaccion))); ?></td>
            </tr>
            <tr>
                <td><strong>Estado:</strong> <?php echo e($transacciones[0]->sEstado); ?> </td>
                <td class="text-right"><strong>Gestion:</strong> <?php echo e($transacciones[0]->sGestion); ?> </td>
            </tr>

            <tr>
                <td colspan="2"> <strong>Unidad Educativa:</strong> <?php echo e($transacciones[0]->sUNegocio); ?> </td>
            </tr>
            <tr>
                <td colspan="2"> <strong>Cliente:</strong> <?php echo e($transacciones[0]->sCliente); ?></td>
            </tr>
            <tr>
                <td colspan="2"> <strong>Glosa:</strong> <?php echo e($transacciones[0]->sGlosa); ?></td>
            </tr>

        </table>
    </div>
    <hr>
    <br>

    <table class="table border text-center">
        <thead>
            <tr>
                <th><strong>Codigo</strong></th>
                <th><strong>Concepto</strong></th>
                <th><strong>Monto</strong></th>
                <th><strong>Cantidad</strong></th>
                <th><strong>SubTotal</strong></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = json_decode($transacciones[0]->Detalle); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border">
                <td><?php echo e($detalle->lDConcepto_id); ?></td>
                <td class="text-left"><?php echo e($detalle->sConcepto); ?></td>
                <td><?php echo e(number_format($detalle->lMonto, 2)); ?></td>
                <td><?php echo e($detalle->lCantidad); ?></td>
                <td><?php echo e(number_format($detalle->lSubTotal, 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr>

                <td><strong></strong></td>
                <td><strong></strong></td>
                <td><strong></strong></td>
                <td class="text-right"><strong>TOTAL:</strong></td>
                <td><strong><?php echo e($transacciones[0]->lTotal); ?></strong></td>

            </tr>
        </tbody>
    </table>

    <div id="footer">
        <hr>
        <p class="textfooter"> Dirección: <?php echo e($unegocios[0]->sDireccion); ?> <?php echo e($unegocios[0]->sCiudad); ?> - Bolivia </p>
    </div>

</body>

</html><?php /**PATH /home/jmfyacom/pagos.jmfya.com/resources/views/transacciones/reporte.blade.php ENDPATH**/ ?>