

<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Formulario para crear una nueva transacción aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-primary" href="<?php echo e(route('transacciones.index')); ?>"> Volver</a>
        </div>
    </div>
</div>
<?php if($errors->any()): ?>
<div class="alert alert-danger">
    <strong>Falla!!</strong> Tenemos problemas al insertar datos.<br><br>
    <ul>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>
<?php
$GestionID = (int)session('GestionID'); //  1; //$_SESSION['GestionID'];
$UNegocioID = (int)session('UNegocioID');
?>
<form action="<?php echo e(route('transacciones.store')); ?>" method="POST" name="frmCabecera" id="frmCabecera">
    <?php echo csrf_field(); ?>
    <div class="row">
        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Gestión Academica:</strong>
                <div class="form-group">
                    <select id="lGestion_id" class="form-control" name="lGestion_id">
                        <option value="" disabled>-- Escoja Gestión --</option>
                        <?php $__currentLoopData = $cboGestiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lista->lGestion_id); ?>" <?php if ($lista->lGestion_id == $GestionID) : ?> selected <?php else : ?> disabled <?php endif; ?>><?php echo e($lista->sGestion); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Unidad Educativa:</strong>
                <div class="form-group">
                    <select id="lUNegocio_id" class="form-control" name="lUNegocio_id">
                        <option value="" disabled>-- Escoja Unidad --</option>
                        <?php $__currentLoopData = $cboUNegocios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lista->lUNegocio_id); ?>" <?php if ($lista->lUNegocio_id == $UNegocioID) : ?> selected <?php else : ?> disabled <?php endif; ?>><?php echo e($lista->sDescripcion); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Tipo Transacción:</strong>
                <div class="form-group">
                    <select id="lTipo" onchange="loadConceptos(this)" class="form-control w-full bg-white rounded shadow" name="lTipo">
                        <option value="" selected>-- Tipo Movimiento --</option>
                        <?php $__currentLoopData = $cboTipoTransacciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lista->lValue_id); ?>" <?php if ($lista->lValue_id == 1) : ?> ' ' <?php else : ?> ' ' <?php endif; ?>> <?php echo e($lista->sParametro); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Estudiante:</strong>
                <div class="form-group">
                    <select id="lRegistro_id" onchange="loadValues(this)" class="form-control" name="lRegistro_id">
                        <option value="">-- Escoja Estudiante --</option>
                        <?php $__currentLoopData = $cboRegistros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lista->lRegistro_id); ?>"><?php echo e($lista->sEstudiante .' '. $lista->sGrupo); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <!--
        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>RFI-ID:</strong>
                <div class="form-group">
                    <div class="btn-group">
                        <input type="text" name="rfid" id="rfid" class="form-control" placeholder="RFI-ID">
                        <button id="btnBuscar" name="btnBuscar" class="btn add-btn btn-secondary" onclick="leerEstudiante(this)">
                            <i class="bi bi-search"></i>
                        </button>

                    </div>
                </div>
            </div>
        </div>
                        -->
        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Cliente:</strong>
                <input type="text" class="form-control" name="sCliente" id="sCliente" placeholder="Nombre del cliente">
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Glosa:</strong>
                <input type="text" class="form-control" name="sGlosa" placeholder="Glosa de la transaccion">
            </div>
        </div>


        <!-- <form id="transactionForm">-->
        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <strong>Conceptos:</strong>
                <div class="form-group">
                    <select id="lDConcepto_id" onchange="loadPrecios(this)" class="form-control" name="lDConcepto_id">
                        <option value="">-- Escoja Concepto --</option>
                        <?php $__currentLoopData = $cboConceptos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lista->lDConcepto_id); ?>"><?php echo e($lista->sConcepto); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <strong>Monto:</strong>
                <input type="number" class="form-control" id="lMonto" name="lMonto" value="0" placeholder="Monto" min="1" step="1" require>
            </div>
        </div>
        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <strong>Cantidad:</strong>
                <input type="number" class="form-control" name="lCantidad" value="1" placeholder="Cantidad" min="1" max="10" require>
            </div>
        </div>
        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <br>
                <button id="botonDeEnvio" name="botonDeEnvio" class="btn add-btn btn-info">
                    <i class="bi bi-plus-circle"></i>
                </button>
            </div>
        </div>
        <!--</form>-->
    </div>
</form>
<div class="table-responsive-sm">
    <table class="table table-hover table-sm" id="transactionTable" name="transactionTable">
        <thead class="table-dark">
            <tr>
                <th width="50px">ID</th>
                <th width="80px">Concepto</th>
                <th width="80px">Monto</th>
                <th width="80px">Cantidad</th>
                <th width="80px">Sub Total</th>
                <th width="80px">Action</th>
            </tr>
        </thead>

        <tbody>
            <tr>
                <td> </td>
                <td> </td>
                <td> </td>
                <td> <strong>Total:</strong> </td>
                <td>
                    <input type="text" class="form-control" id="lTotal" name="lTotal" value="0" readonly="true">
                </td>
                <td>
                    <div name="boton" id="boton"></div>
                </td>
            </tr>
        </tbody>
    </table>
    <hr>
</div>

<div class="col-xs-12 col-sm-12 col-md-12 text-center">
    <button id="btnEnviar" name="btnEnviar" onclick="guardarDatos(this)" type="submit" class="btn btn-primary">Enviar</button>
</div>

<script>
    // para seleccionar solo conceptos de acuerdo a un tipo Ingreso o Egreso
    function loadConceptos(TipoTransaccion) {
        let tTransaccion = TipoTransaccion.value;
        let plGestionID = document.getElementById('lGestion_id').value; // 1;
        let plUNegocioID = document.getElementById('lUNegocio_id').value;
        fetch(`conceptos/${tTransaccion}/${plGestionID}/${plUNegocioID}/tipo-transaccion`)
            .then(response => response.json())
            .then(jsonData => builConceptosSelect(jsonData))
        //console.log(JSON.stringify(jsonData));                                
    }

    function builConceptosSelect(jsonConceptos) {
        let conceptosSelect = document.getElementById('lDConcepto_id');
        clearSelect(conceptosSelect);
        jsonConceptos.forEach(concepto => {
            let optionTag = document.createElement('option');
            optionTag.value = concepto.lDConcepto_id;
            optionTag.innerHTML = concepto.sConcepto;
            conceptosSelect.append(optionTag);
        })
    }

    function clearSelect(select) {
        while (select.options.length > 1) {
            select.remove(1);
        }
    }
    //fin de seleccion de conceptos.
    // Funcion para buscar estudiante por RFID, nombre, etc.
    function leerEstudiante(id){
        let pvalorBusqueda = document.getElementById('rfid').value;
        console.log(pvalorBusqueda);
    }
    //para cargar nombre de estudiante al cliente y generar glosa
    function loadValues(pEstudiante) {
        /* Para obtener el texto */
        var texto = pEstudiante.options[pEstudiante.selectedIndex].text;
        //console.log(texto); format(date, 'dd/MM/yyyy'); + 
        var tDate = new Date().toLocaleDateString().replace('/', '-');
        document.frmCabecera.sCliente.value = texto;
        document.frmCabecera.sGlosa.value = tDate.replace('/', '-') + ' ' + texto;
    }
    // fin asignacion de valores cliente y GLOSA
    function loadPrecios(pDConcepto) {
        let lDConceptoID = pDConcepto.value;
        let lRegistroID = document.getElementById('lRegistro_id').value;

        fetch(`DConceptos/${lDConceptoID}/${lRegistroID}/Det-Conceptos`)
            .then(response => response.json())
            .then(jsonData => loadMontos(jsonData))
        // console.log(JSON.stringify(jsonData)))
    }

    function loadMontos(jsonValores) {
        var plMonto = jsonValores[0].lMonto;
        var plTipo = jsonValores[0].lTipoDConcepto;
        document.frmCabecera.lMonto.value = plMonto;
        if (plTipo == 1) document.frmCabecera.lMonto.readOnly = true;
        else document.frmCabecera.lMonto.readOnly = false;

    }
    const form = document.getElementById('frmCabecera');
    const btnEnviar = document.querySelector('btnEnviar');

    form.addEventListener("submit", function(event) {
        event.preventDefault();
        const form = document.getElementById('frmCabecera');
        addRow()
    })
    //Funcion para incertar una fila a la tabla
    function addRow() {
        let transactionFormData = new FormData(form);
        if (transactionFormData.get("lMonto") > 0 && transactionFormData.get("lDConcepto_id") > 0) {
            let transactionTableRef = document.getElementById('transactionTable');
            let newTransactionRowRef = transactionTableRef.insertRow(1); //Insertando fila
            //Insertando Celdas a la fila adicionado
            let newTransactionCellRef = newTransactionRowRef.insertCell(0);
            newTransactionCellRef.textContent = transactionFormData.get("lDConcepto_id");
            newTransactionCellRef = newTransactionRowRef.insertCell(1);
            let pConcepto = document.getElementById('lDConcepto_id');
            var texto = pConcepto.options[pConcepto.selectedIndex].text;
            newTransactionCellRef.textContent = texto;
            newTransactionCellRef = newTransactionRowRef.insertCell(2);
            newTransactionCellRef.textContent = transactionFormData.get("lMonto");
            newTransactionCellRef = newTransactionRowRef.insertCell(3);
            newTransactionCellRef.textContent = transactionFormData.get("lCantidad");
            newTransactionCellRef = newTransactionRowRef.insertCell(4);
            newTransactionCellRef.textContent = transactionFormData.get("lMonto") * transactionFormData.get("lCantidad");

            newTransactionCellRef = newTransactionRowRef.insertCell(5);
            newTransactionCellRef.innerHTML = `<button id="btnQuitar" onclick="QuitarFila(this)" class="btn add-btn btn-danger"><i class="bi bi-x-octagon"></i></button>`;

            lTotal.value = parseInt(lTotal.value) + (transactionFormData.get("lMonto") * transactionFormData.get("lCantidad"));
            document.frmCabecera.lCantidad.value = "1";
        } else {
            Swal.fire('Alerta', 'El Monto debe ser mayor a "0" \n o elija el concepto', 'error')
        }
    }
    //Funcion para quitar una fila de la tabla
    function QuitarFila(Id) {
        let row = Id.parentNode.parentNode;
        let table = document.getElementById("transactionTable");
        //console.log (row.cells[4].textContent);
        lTotal.value = parseInt(lTotal.value) - parseInt(row.cells[4].textContent);
        table.deleteRow(row.rowIndex);
    }
    // Funcion para guardar datos del detalle !!Importante¡¡¡¡
    function guardarDatos(id) {
        if (lTotal.value > 0) {
            var trans = [];
            trans[0] = (document.frmCabecera.lTipo.value);
            trans[1] = (document.frmCabecera.sCliente.value);
            trans[2] = (lTotal.value);
            trans[3] = (document.frmCabecera.lRegistro_id.value);
            trans[4] = (document.frmCabecera.lGestion_id.value);
            trans[5] = (document.frmCabecera.lUNegocio_id.value);
            trans[6] = (document.frmCabecera.sGlosa.value);

            var resume_table = document.getElementById("transactionTable");
            var filas = resume_table.rows.length;
            var colums = resume_table.rows[0].cells.length;
            var text = [];
            var dTrans = [];
            for (var f = 1; f < filas - 1; f++) {
                for (var c = 0; c < colums - 1; c++) {
                    text[c] = (resume_table.rows[f].cells[c].innerText);
                }
                dTrans[f - 1] = text;
                text = [];
            }
            var transaccion = [trans, dTrans];
            fetch(`Transacciones/${transaccion}/trans-dTrans`)
                .then(response => window.open("../transacciones", "_self"))
            //window.open("../transacciones", "_self");
        } else {
            Swal.fire('Alerta', 'El total debe ser mayor a "0"', 'error')
        }
    }    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\app_pagos\resources\views/transacciones/create.blade.php ENDPATH**/ ?>