
<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Conceptos</h1>
<hr>
<!-- Mostrar la lista de conceptos aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('conceptos.create')); ?>"> Nuevo Concepto</a>
        </div>
    </div>
</div>
<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>
<?php endif; ?>

<table class="table table-hover table-sm">
    <thead class="table-dark">
        <tr>
            <th width="50px">Nro.</th>
            <th width="80px">Concepto</th>
            <th width="80px">Tipo</th>
            <th width="80px">Estado</th>
            <th width="180px">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $conceptos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $concepto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($concepto->lConcepto_id); ?></td>
            <td><?php echo e($concepto->sConcepto); ?></td>
            <td><?php echo e($concepto->sParametro); ?></td>
            <td><?php if ($concepto->boolEstado == 1) : ?>
                    <strong>Activa</strong>
                <?php else : ?>
                    <strong>No ACTIVA!!</strong>
                <?php endif ?>
            </td>
            <td>
                <?php if ($concepto->boolEstado == 1) : ?>
                    <form action="<?php echo e(route('conceptos.destroy',$concepto->lConcepto_id)); ?>" method="POST">
                        <a class="btn btn-info" href="<?php echo e(route('conceptos.show',encrypt($concepto->lConcepto_id))); ?>">Show</a>
                        <a class="btn btn-primary" href="<?php echo e(route('conceptos.edit', encrypt($concepto->lConcepto_id))); ?>">Editar</a>
                        <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>No activo!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\app_pagos\resources\views/conceptos/index.blade.php ENDPATH**/ ?>