
<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Planes de Pagos</h1>
<hr>
<!-- Mostrar la lista de planes de pagos aquí -->
<div class="row">
    <div class="col-lg-6 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('planPagos.create')); ?>"> Nuevo Registro</a>
        </div>
    </div>
    <div class="col margin-tb">
        <div class="d-md-flex justify-content-md-end">
            <form action="<?php echo e(route('planPagos.index')); ?>" method="GET">
                <div class="btn-group">
                    <input type="text" name="flBuscar" class="form-control" placeholder="Valor a buscar">
                    <input type="submit" value="Filtrar" class="btn btn-primary">
                </div>
            </form>
        </div>
    </div> 
</div>
<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>
<?php endif; ?>
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">Nro.</th>
                <th width="80px">Gestion</th>
                <th width="80px">Unidad Educativa</th>
                <th width="80px">Estudiante</th>
                <th width="80px">Monto</th>
                <th width="80px">Saldo</th>
                <th width="80px">Pagado</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        <?php $__currentLoopData = $planpagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planpago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tbody>
            <tr>
                <td><?php echo e($planpago->lRegistro_id); ?></td>
                <td><?php echo e($planpago->sGestion); ?></td>
                <td><?php echo e($planpago->sDescripcion); ?></td>
                <td><?php echo e($planpago->sEstudiante); ?></td>
                <td><?php echo e($planpago->lMonto); ?></td>
                <td><?php echo e($planpago->lDeuda); ?></td>
                <td><?php echo e($planpago->lPagado); ?></td>

                <td>
                    <?php if ($planpago->lDeuda > 0) : ?>
                        <form action="<?php echo e(route('planPagos.destroy',$planpago->lRegistro_id)); ?>" method="POST">
                            <a class="btn btn-info" href="<?php echo e(route('planPagos.show',encrypt($planpago->lRegistro_id))); ?>" target="_blank"> show </a>
                            <!--<a class="far fa-edit btn btn-primary" href="<?php echo e(route('planPagos.edit', encrypt($planpago->lRegistro_id))); ?>"> </a>-->
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn"></button>
                        </form>
                    <?php else : ?>
                        <strong>Pagado!!</strong>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    <hr>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\app_pagos\resources\views/planPagos/index.blade.php ENDPATH**/ ?>