
<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Gestiones.</h1>
<hr>
<!-- Mostrar la lista de gestiones aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('gestiones.create')); ?>"> Nueva Gestión</a>
        </div>
    </div>
</div>

<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>
<!--<div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>-->
<?php endif; ?>

<table class="table table-hover table-sm">
    <thead class="table-dark">
        <tr>
            <th width="50px">Nro.</th>
            <th width="80px">Gestión</th>
            <th width="80px">Inicio</th>
            <th width="80px">Fin</th>
            <th width="50px">Meses</th>
            <th width="100px">Descripcion</th>
            <th width="180px">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $gestiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($gestion->lGestion_id); ?></td>
            <td><?php echo e($gestion->sGestion); ?></td>
            <td><?php echo e(date("d/m/Y", strtotime($gestion->dtInicio))); ?></td>
            <td><?php echo e(date("d/m/Y", strtotime($gestion->dtFinal))); ?></td>
            <td><?php echo e($gestion->lMeses); ?></td>
            <td><?php echo e($gestion->sDescripcion); ?></td>
            <td>
                <?php if ($gestion->boolEstado == 1) : ?>
                    <form action="<?php echo e(route('gestiones.destroy',$gestion->lGestion_id)); ?>" method="POST">
                        <a class="btn btn-info" href="<?php echo e(route('gestiones.show',encrypt($gestion->lGestion_id))); ?>">Show</a>
                        <a class="btn btn-primary" href="<?php echo e(route('gestiones.edit',encrypt($gestion->lGestion_id))); ?>">Editar</a>
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>Gestión Cerrada!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>


<!--
        <div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4>Gestiones</h4>
                    <div class="text-end">
                        <?php echo $__env->make('buttons.previous', ['route' => url()->previous()], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('buttons.new', ['route' => route('gestiones.create')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="card-body">
                    <person-list
                        route_list="<?php echo e(url('gestiones/show/vue-list')); ?>"
                        route_delete="<?php echo e(url('people')); ?>"
                        route_edit="<?php echo e(url('gestiones/{id}/edit')); ?>"
                        route_show="<?php echo e(url('gestiones/{id}')); ?>">
					</person-list>
                    </div>
                </div>
            </div>
        </div>
    </div>-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\app_pagos\resources\views/gestiones/index.blade.php ENDPATH**/ ?>