<!-- @//extends('adminlte::auth.login')-->
<!--@//extends('layouts.app')
@//section('content') -->
<!doctype html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>App-Pagos</title>
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<style>
    /* ❤  */
    @import url('https://fonts.googleapis.com/css?family=Poppins:400,500,600,700,800,900');

    body {
        font-family: 'Poppins', sans-serif;
        font-weight: 300;
        font-size: 15px;
        line-height: 1.7;
        color: #c4c3ca;
        background-color: #154073;
        /*background-image: url("img/gif/dances.gif");*/
        background-position: center 25%;
        background-size: cover;
        overflow-x: hidden;
        margin: 0;        
    }

    /* para animacion de fondo*/
    
    #particles-js {
        position: absolute;
        width: 100%;
        height: 100%;
        background-color: #154073;
        background-image: url("");
        background-repeat: no-repeat;
        background-size: cover;
        background-position: 50% 50%;
    }

    .count-particles {
        background: #000050;
        position: absolute;
        top: 20px;
        left: 0;
        width: 80px;
        color: #ffffff;
        font-size: .8em;
        text-align: left;
        text-indent: 4px;
        line-height: 14px;
        padding-bottom: 2px;
        font-family: Helvetica, Arial, sans-serif;
        font-weight: bold;
        border-radius: 0 0 3px 3px;
    }

    .js-count-particles {
        font-size: 1.1em;
    }
    /* fin de animacion */
    a {
        cursor: pointer;
        transition: all 200ms linear;
    }

    a:hover {
        text-decoration: none;
    }

    .link {
        color: #c4c3ca;
    }

    .link:hover {
        color: #ffeba7;
    }

    p {
        font-weight: 500;
        font-size: 14px;
        line-height: 1.7;
    }

    h4 {
        font-weight: 600;
    }

    h6 span {
        padding: 0 20px;
        text-transform: uppercase;
        font-weight: 700;
    }

    .section {
        position: relative;
        width: 100%;
        display: block;
    }

    .full-height {
        min-height: 100vh;
    }

    [type="checkbox"]:checked,
    [type="checkbox"]:not(:checked) {
        position: absolute;
        left: -9999px;
    }

    .checkbox:checked+label,
    .checkbox:not(:checked)+label {
        position: relative;
        display: block;
        text-align: center;
        width: 60px;
        height: 16px;
        border-radius: 8px;
        padding: 0;
        margin: 10px auto;
        cursor: pointer;
        background-color: #ffeba7;
    }

    .checkbox:checked+label:before,
    .checkbox:not(:checked)+label:before {
        position: absolute;
        display: block;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        color: #ffeba7;
        background-color: #102770;
        font-family: 'unicons';
        content: '\eb4f';
        z-index: 20;
        top: -10px;
        left: -10px;
        line-height: 36px;
        text-align: center;
        font-size: 24px;
        transition: all 0.5s ease;
    }

    .checkbox:checked+label:before {
        transform: translateX(44px) rotate(-270deg);
    }


    .card-3d-wrap {
        position: relative;
        width: 440px;
        max-width: 100%;
        height: 400px;
        -webkit-transform-style: preserve-3d;
        transform-style: preserve-3d;
        perspective: 800px;
        margin-top: 60px;
    }

    .card-3d-wrapper {
        width: 100%;
        height: 100%;
        position: absolute;
        top: 0;
        left: 0;
        -webkit-transform-style: preserve-3d;
        transform-style: preserve-3d;
        transition: all 600ms ease-out;
    }

    .card-front,
    .card-back {
        width: 100%;
        height: 100%;
        background-color: #033055;
        background-image: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/1462889/pat.svg');
        /*background-image: url('img/logoIcon.jpeg');*/
        background-position: bottom center;
        background-repeat: no-repeat;
        background-size: 200%;
        position: absolute;
        border-radius: 6px;
        left: 0;
        top: 0;
        -webkit-transform-style: preserve-3d;
        transform-style: preserve-3d;
        -webkit-backface-visibility: hidden;
        -moz-backface-visibility: hidden;
        -o-backface-visibility: hidden;
        backface-visibility: hidden;
    }

    .card-back {
        transform: rotateY(180deg);
    }

    .checkbox:checked~.card-3d-wrap .card-3d-wrapper {
        transform: rotateY(180deg);
    }

    .center-wrap {
        position: absolute;
        width: 100%;
        padding: 0 35px;
        top: 50%;
        left: 0;
        transform: translate3d(0, -50%, 35px) perspective(100px);
        z-index: 20;
        display: block;
    }


    .form-group {
        position: relative;
        display: block;
        margin: 0;
        padding: 0;
    }

    .form-style {
        padding: 13px 20px;
        padding-left: 55px;
        height: 48px;
        width: 100%;
        font-weight: 500;
        border-radius: 4px;
        font-size: 14px;
        line-height: 22px;
        letter-spacing: 0.5px;
        outline: none;
        color: #c4c3ca;
        background-color: #1f2029;
        border: none;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
        box-shadow: 0 4px 8px 0 rgba(21, 21, 21, .2);
    }

    .form-style:focus,
    .form-style:active {
        border: none;
        outline: none;
        box-shadow: 0 4px 8px 0 rgba(21, 21, 21, .2);
    }

    .input-icon {
        position: absolute;
        top: 0;
        left: 18px;
        height: 48px;
        font-size: 24px;
        line-height: 48px;
        text-align: left;
        color: #ffeba7;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input:-ms-input-placeholder {
        color: #c4c3ca;
        opacity: 0.7;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input::-moz-placeholder {
        color: #c4c3ca;
        opacity: 0.7;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input:-moz-placeholder {
        color: #c4c3ca;
        opacity: 0.7;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input::-webkit-input-placeholder {
        color: #c4c3ca;
        opacity: 0.7;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input:focus:-ms-input-placeholder {
        opacity: 0;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input:focus::-moz-placeholder {
        opacity: 0;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input:focus:-moz-placeholder {
        opacity: 0;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .form-group input:focus::-webkit-input-placeholder {
        opacity: 0;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
    }

    .btn {
        border-radius: 4px;
        height: 44px;
        font-size: 13px;
        font-weight: 600;
        text-transform: uppercase;
        -webkit-transition: all 200ms linear;
        transition: all 200ms linear;
        padding: 0 30px;
        letter-spacing: 1px;
        display: -webkit-inline-flex;
        display: -ms-inline-flexbox;
        display: inline-flex;
        -webkit-align-items: center;
        -moz-align-items: center;
        -ms-align-items: center;
        align-items: center;
        -webkit-justify-content: center;
        -moz-justify-content: center;
        -ms-justify-content: center;
        justify-content: center;
        -ms-flex-pack: center;
        text-align: center;
        border: none;
        background-color: #ffeba7;
        color: #102770;
        box-shadow: 0 8px 24px 0 rgba(255, 235, 167, .2);
    }

    .btn:active,
    .btn:focus {
        background-color: #102770;
        color: #ffeba7;
        box-shadow: 0 8px 24px 0 rgba(16, 39, 112, .2);
    }

    .btn:hover {
        background-color: #102770;
        color: #ffeba7;
        box-shadow: 0 8px 24px 0 rgba(16, 39, 112, .2);
    }

    .logo {
        position: absolute;
        top: 30px;
        right: 30px;
        display: block;
        z-index: 100;
        transition: all 250ms linear;
    }

    .logo img {
        height: 26px;
        width: auto;
        display: block;
    }
</style>
<?php

use Illuminate\Support\Facades\DB;

$cboGestiones = DB::select('call pGestiones(0,null,null,null,1,null,null,4)');
if (isset($_POST["ingresar"])) {
    session(['GestionID' => htmlentities($_POST["lGestion_id"])]);
    session(['UNegocioID' => htmlentities($_POST["lUNegocio_id"])]);
    dd(session());
}
?>

<body>
    <div id="particles-js"></div>
    <div class="count-particles">
        <span class="js-count-particles">--</span> 2024
    </div>

    <div id="app">
        <main class="py-0">

            <a href="#" class="logo">
                <img src="img/logoIcon.jpeg" alt="">
            </a>
            <div>
                <div>
                    <div class="row full-height justify-content-center">
                        <div class="col-12 text-center align-self-center py-1">
                            <div class="section pb-5 pt-5 pt-sm-2">

                                <h6 class="mb-0 pb-3 text-center"><span>Login </span><span>Parametros</span></h6>
                                <input class="checkbox" type="checkbox" id="reg-log" name="reg-log" />
                                <label for="reg-log"></label>

                                <div class="card-3d-wrap mx-auto">
                                    <form class="form-horizontal" method="POST" action="<?php echo e(url('/login')); ?>">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="card-3d-wrapper">
                                            <div class="card-front">
                                                <div class="center-wrap">
                                                    <div class="section text-center">
                                                        <h4 class="mb-4 pb-3">Ingresar al sistema</h4>
                                                        <hr>
                                                        <div class="form-group mt<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                                                            <label for="email" class="col-md-4 control-label">E-Mail </label>
                                                            <div class="form-group mt-2">
                                                                <input id="email" type="email" onchange="loadValores(this)" class="form-style" name="email" value="<?php echo e(old('email')); ?>" required autofocus placeholder="e-mail" autocomplete="off">
                                                                <?php if($errors->has('email')): ?>
                                                                <span class="help-block">
                                                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                                                </span>
                                                                <?php endif; ?>
                                                                <i class="input-icon uil uil-at"></i>
                                                            </div>
                                                        </div>
                                                        <div class="form-group mt-2">
                                                            <label for="password" class="col-md-4 control-label">Password</label>
                                                            <div class="form-group mt-2">
                                                                <i class="input-icon uil uil-lock-alt"></i>
                                                                <input id="password" type="password" class="form-style" name="password" placeholder="Contraseña.." autocomplete="off" required>
                                                                <?php if($errors->has('password')): ?>
                                                                <span class="help-block">
                                                                    <strong><?php echo e($errors->first('password')); ?></strong>
                                                                </span>
                                                                <?php endif; ?>
                                                            </div>

                                                        </div>
                                                        <!--
                                            <div class="form-group">
                                                <div class="col-md-6 col-md-offset-4">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" name="remember"> Recordarme..?
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>-->
                                                        <div class="form-group">
                                                            <!--   <div >
                                                    <button type="submit" class="btn mt-4 btn-primary">
                                                        Ingresar
                                                    </button>  
                                                </div>-->
                                                            <a class="link-warning link-offset-2 link-underline-opacity-25 link-underline-opacity-100-hover" href="<?php echo e(url('/password/reset')); ?>">
                                                                Olvidaste tu password?
                                                            </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-back">
                                                <div class="center-wrap">
                                                    <div class="section">
                                                        <h4 class="mb-4 pb-3">Parametros</h4>
                                                        <hr>

                                                        <div class="form-group mt-2">
                                                            <label for="lGestion_id" class="col-md-4 control-label">Gestión</label>
                                                            <div class="form-group">
                                                                <select id="lGestion_id" name="lGestion_id" required class="form-style" aria-label="Default select example">
                                                                    <option value="" disabled>-- Escoja Gestión --</option>
                                                                    <?php $__currentLoopData = $cboGestiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($lista->lGestion_id); ?>"><?php echo e($lista->sGestion); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                                <?php if($errors->has('lGestion_id')): ?>
                                                                <span class="help-block">
                                                                    <strong><?php echo e($errors->first('lGestion_id')); ?></strong>
                                                                </span>
                                                                <?php endif; ?>
                                                                <i class="input-icon uil uil-user"></i>
                                                            </div>
                                                        </div>

                                                        <div class="form-group mt-2">
                                                            <label for="lUNegocio_id" class="col-md-6 control-label">Unidad Educativa</label>
                                                            <div class="form-group mt-2">
                                                                <select id="lUNegocio_id" name="lUNegocio_id" required class="form-style" aria-label="Default select example">
                                                                    <option disabled selected>-- Unidad Educativa --</option>
                                                                </select>
                                                                <?php if($errors->has('lUNegocio_id')): ?>
                                                                <span class="help-block">
                                                                    <strong><?php echo e($errors->first('lUNegocio_id')); ?></strong>
                                                                </span>
                                                                <?php endif; ?>

                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <div>
                                                                <input type="submit" class="btn mt-4 btn-primary" value="Ingresar" name="ingresar">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- <i class='fas fa-user-graduate'>sdfgsdf</i>-->

            <script>
                // para seleccionar solo conceptos de acuerdo a un tipo Ingreso o Egreso
                function loadValores(pusuario) {
                    let semail = pusuario.value;
                    fetch(`login/${semail}/usuarios`)
                        .then(response => response.json())
                        .then(jsonData => builConceptosSelect(jsonData))
                    //console.log(JSON.stringify(jsonData));                                
                }

                function builConceptosSelect(jsonConceptos) {
                    let unegociosSelect = document.getElementById('lUNegocio_id');
                    clearSelect(unegociosSelect);
                    jsonConceptos.forEach(UNegocio => {
                        let optionTag = document.createElement('option');
                        optionTag.value = UNegocio.lUNegocio_id;
                        optionTag.innerHTML = UNegocio.sUNegocio;
                        unegociosSelect.append(optionTag);
                    })
                }

                function clearSelect(select) {
                    while (select.options.length > 1) {
                        select.remove(1);
                    }
                }
            </script>
            <!--@//endsection-->
            <script>
                particlesJS("particles-js", {
                    "particles": {
                        "number": {
                            "value": 380,
                            "density": {
                                "enable": true,
                                "value_area": 800
                            }
                        },
                        "color": {
                            "value": "#ffffff"
                        },
                        "shape": {
                            "type": "circle",
                            "stroke": {
                                "width": 0,
                                "color": "#000000"
                            },
                            "polygon": {
                                "nb_sides": 5
                            },
                            "image": {
                                "src": "img/github.svg",
                                "width": 100,
                                "height": 100
                            }
                        },
                        "opacity": {
                            "value": 0.5,
                            "random": false,
                            "anim": {
                                "enable": false,
                                "speed": 1,
                                "opacity_min": 0.1,
                                "sync": false
                            }
                        },
                        "size": {
                            "value": 3,
                            "random": true,
                            "anim": {
                                "enable": false,
                                "speed": 40,
                                "size_min": 0.1,
                                "sync": false
                            }
                        },
                        "line_linked": {
                            "enable": true,
                            "distance": 150,
                            "color": "#ffffff",
                            "opacity": 0.4,
                            "width": 1
                        },
                        "move": {
                            "enable": true,
                            "speed": 6,
                            "direction": "none",
                            "random": false,
                            "straight": false,
                            "out_mode": "out",
                            "bounce": false,
                            "attract": {
                                "enable": false,
                                "rotateX": 600,
                                "rotateY": 1200
                            }
                        }
                    },
                    "interactivity": {
                        "detect_on": "canvas",
                        "events": {
                            "onhover": {
                                "enable": true,
                                "mode": "grab"
                            },
                            "onclick": {
                                "enable": true,
                                "mode": "push"
                            },
                            "resize": true
                        },
                        "modes": {
                            "grab": {
                                "distance": 140,
                                "line_linked": {
                                    "opacity": 1
                                }
                            },
                            "bubble": {
                                "distance": 900,
                                "size": 40,
                                "duration": 2,
                                "opacity": 8,
                                "speed": 3
                            },
                            "repulse": {
                                "distance": 200,
                                "duration": 0.4
                            },
                            "push": {
                                "particles_nb": 4
                            },
                            "remove": {
                                "particles_nb": 2
                            }
                        }
                    },
                    "retina_detect": true
                });


                /* ---- stats.js config ---- */

                var count_particles, stats, update;
                stats = new Stats;
                stats.setMode(0);
                stats.domElement.style.position = 'absolute';
                stats.domElement.style.left = '0px';
                stats.domElement.style.top = '0px';
                document.body.appendChild(stats.domElement);
                count_particles = document.querySelector('.js-count-particles');
                update = function() {
                    stats.begin();
                    stats.end();
                    if (window.pJSDom[0].pJS.particles && window.pJSDom[0].pJS.particles.array) {
                        count_particles.innerText = window.pJSDom[0].pJS.particles.array.length;
                    }
                    requestAnimationFrame(update);
                };
                requestAnimationFrame(update);
            </script>
        </main>
    </div>
    <script src="js/particles.js"></script>
    <script src="js/app.js"></script>
</body>

</html><?php /**PATH C:\laragon\www\app_pagos\resources\views/auth/login.blade.php ENDPATH**/ ?>