
<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Registros</h1>
<hr>
<!-- Mostrar la lista de registros aquí -->
<div class="row">
    <div class="col-lg-6 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('registros.create')); ?>"> Nuevo Registro</a>
        </div>
    </div>
    <div class="col margin-tb">
        <div class="d-md-flex justify-content-md-end">
            <form action="<?php echo e(route('registros.index')); ?>" method="GET">
                <div class="btn-group">
                    <input type="text" name="flBuscar" class="form-control" placeholder="Valor a buscar">
                    <input type="submit" value="Filtrar" class="btn btn-primary">
                </div>
            </form>
        </div>
    </div>
</div>
<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>
<?php endif; ?>
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">Nro.</th>
                <th width="80px">Fecha</th>
                <th width="80px">Estudiante</th>
                <th width="80px">Grupo</th>
                <th width="80px">Gestion</th>
                <th width="80px">Estado</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        <?php $__currentLoopData = $registros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $registro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tbody>
            <tr>
                <td><?php echo e($registro->lRegistro_id); ?></td>
                <td><?php echo e(date("d/m/Y", strtotime($registro->dtRegistro))); ?></td>
                <td><?php echo e($registro->sEstudiante); ?></td>
                <td><?php echo e($registro->sCurso); ?></td>
                <td><?php echo e($registro->sGestion); ?></td>

                <td><?php if ($registro->boolEstado == 1) : ?>
                        <strong>Confirmado</strong>
                    <?php else : ?>
                        <strong>Anulado</strong>
                    <?php endif ?>
                </td>
                <td>
                    <?php if ($registro->boolEstado == 1) : ?>
                        <form action="<?php echo e(route('registros.destroy',$registro->lRegistro_id)); ?>" method="POST">
                            <!--<a class="btn btn-info" href="<?php echo e(route('registros.show',encrypt($registro->lRegistro_id))); ?>">Show</a>
                            <a class="btn btn-primary" href="<?php echo e(route('registros.edit', encrypt($registro->lRegistro_id))); ?>">Editar</a>
                    -->
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger">Anular</button>
                        </form>
                    <?php else : ?>
                        <strong>No activo!!</strong>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    <hr>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmfyacom/pagos.jmfya.com/resources/views/registros/index.blade.php ENDPATH**/ ?>