
<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Unidades Educativas:</h1>
<!-- Mostrar la lista de negocios aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('unegocios.create')); ?>"> Nueva Unidad</a>
        </div>
    </div>
</div>
<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>

<?php endif; ?>
<table class="table table-hover table-sm">
    <thead class="table-dark">
        <tr>
            <th width="50px">Nro.</th>
            <th width="80px">Codigo</th>
            <th width="100px">Descripcion</th>
            <th width="80px">Estado</th>
            <th width="180px">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $unegocios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unegocio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($unegocio->lUNegocio_id); ?></td>
            <td><?php echo e($unegocio->sCodigo); ?></td>
            <td><?php echo e($unegocio->sDescripcion .' ('. $unegocio->sTurno.')'); ?></td>
            <td><?php if ($unegocio->boolEstado == 1) : ?>
                    <strong>Activa</strong>
                <?php else : ?>
                    <strong>No ACTIVA!!</strong>
                <?php endif ?>
            </td>
            <td>
                <?php if ($unegocio->boolEstado == 1) : ?>
                    <form action="<?php echo e(route('unegocios.destroy',$unegocio->lUNegocio_id)); ?>" method="POST">
                        <a class="btn btn-info" href="<?php echo e(route('unegocios.show',encrypt($unegocio->lUNegocio_id))); ?>">Show</a>
                        <a class="btn btn-primary" href="<?php echo e(route('unegocios.edit',encrypt($unegocio->lUNegocio_id))); ?>">Editar</a>
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>Unidad No Activa!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\app_pagos\resources\views/unegocios/index.blade.php ENDPATH**/ ?>