
<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Cursos</h1>
<!-- Mostrar la lista de cursos aquí -->
<hr>

<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="<?php echo e(route('cursos.create')); ?>"> Nuevo Curso</a>
        </div>
    </div>
</div>
<?php if($message = Session::get('success')): ?>
<script>
    Swal.fire('Operación', '<?php echo e($message); ?>', 'success')
</script>
<!--<div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>-->
<?php endif; ?>
<table class="table table-hover table-sm">
    <thead class="table-dark">
        <th width="50px">Nro.</th>
        <th width="80px">Curso</th>
        <th width="80px">Descripción</th>
        <th width="180px">Action</th>
    </thead>
    <tbody>
        <?php $__currentLoopData = $cursos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $curso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($curso->lCurso_id); ?></td>
            <td><?php echo e($curso->sCurso); ?></td>
            <td><?php echo e($curso->sDescripcion); ?></td>

            <td>
                <form action="<?php echo e(route('cursos.destroy', encrypt($curso->lCurso_id))); ?>" method="POST">
                    <a class="btn btn-info" href="<?php echo e(route('cursos.show',encrypt($curso->lCurso_id))); ?>">Show</a>
                    <a class="fa fa-edit btn btn-primary" href="<?php echo e(route('cursos.edit', encrypt($curso->lCurso_id))); ?>">Editar</a>
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Cerrar</button>
                </form>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmfyacom/pagos.jmfya.com/resources/views/cursos/index.blade.php ENDPATH**/ ?>