
<?php $__env->startSection('title', 'App-Pagos'); ?>

<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Reporte generales de transacciones</h1>
<hr>
<?php
$GestionID = (int)session('GestionID'); //  1; //$_SESSION['GestionID'];
$UNegocioID = (int)session('UNegocioID');
?>

<div class="row">
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Gestión Academica:</strong>
            <div class="form-group">
                <select id="lGestion_id" class="form-control" name="lGestion_id">
                    <option value="" disabled>-- Escoja Gestión --</option>
                    <?php $__currentLoopData = $cboGestiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($lista->lGestion_id); ?>" <?php if ($lista->lGestion_id == $GestionID) : ?> selected <?php else : ?> disabled <?php endif; ?>><?php echo e($lista->sGestion); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>

    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Unidad Educativa:</strong>
            <div class="form-group">
                <select id="lUNegocio_id" class="form-control" name="lUNegocio_id">
                    <option value="" disabled>-- Escoja Unidad --</option>
                    <?php $__currentLoopData = $cboUNegocios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($lista->lUNegocio_id); ?>" <?php if ($lista->lUNegocio_id == $UNegocioID) : ?> selected <?php else : ?> disabled <?php endif; ?>><?php echo e($lista->sDescripcion); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>

    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Tipo Transacción:</strong>
            <div class="form-group">
                <select id="lTipo" class="form-control w-full bg-white rounded shadow" name="lTipo">
                    <option value="" selected>-- Tipo Movimiento --</option>
                    <?php $__currentLoopData = $cboTipoTransacciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lista): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($lista->lValue_id); ?>" <?php if ($lista->lValue_id == 1) : ?> ' ' <?php else : ?> ' ' <?php endif; ?>> <?php echo e($lista->sParametro); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>

   
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Fecha Inicio:</strong>
            <input type="date" name="dtInicio" id="dtInicio" class="form-control" placeholder="Fecha inicio">
        </div>
    </div>
    <div class="col-xs-4 col-sm-4 col-md-4"> 
        <div class="form-group">
            <strong>Fecha final:</strong>
            <input type="date" name="dtFinal" id ="dtFinal" class="form-control" placeholder="Fecha final">
        </div>
    </div>

</div>
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">            
            <a class="btn btn-info" href="#" onclick="generarReporte()" target="_blank">Print</a>            
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<script>
    function generarReporte() {
        // Obtener el valor seleccionado del <select>
        var lGestionID = document.getElementById('lGestion_id').value;
        var lUNegocioID = document.getElementById('lUNegocio_id').value;
        var dtInicio = document.getElementById('dtInicio').value;
        var dtFinal = document.getElementById('dtFinal').value;
        var lTipo = document.getElementById('lTipo').value;

        // Construir la URL de la ruta del reporte con el valor seleccionado como parámetro        
        var url ="<?php echo e(route('reports.rptGeneral_pdf',[':lGestionID', ':lUNegocioID', ':dtInicio', ':dtFinal', ':lTipo'])); ?>";
        url = url.replace(':lGestionID', lGestionID)
                .replace(':lUNegocioID', lUNegocioID)
                .replace(':dtInicio', dtInicio)
                .replace(':dtFinal', dtFinal)
                .replace(':lTipo', lTipo);

        // Redireccionar a la URL construida
        window.location.href = url;
    }
</script>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmfyacom/pagos.jmfya.com/resources/views/reports/index.blade.php ENDPATH**/ ?>