<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Log;

use App\Http\Controllers\CursoController;
use App\Http\Controllers\RegistroController;
use App\Http\Controllers\PlanPagoController;
use App\Http\Controllers\TransaccionController;
use App\Http\Controllers\GestionController;
use App\Http\Controllers\ConceptoController;
use App\Http\Controllers\DConceptoController;
use App\Http\Controllers\DTransaccionController;
use App\Http\Controllers\EstudianteController;
use App\Http\Controllers\UNegocioController;
use App\Http\Controllers\ValGrupoController;
use App\Http\Controllers\ValParametroController;
use App\Http\Controllers\GrupoController;
use App\Http\Controllers\AdminController;

use App\Http\Controllers\rptGeneralController;
use App\Http\Controllers\rptXCursoController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Auth::routes();
Route::get('/', function () {
    return view('welcome');
});

/*Auth::routes();*/

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

/*Auth::routes();*/

Route::get('/home', function () {
    return view('home');
})->name('home')->middleware('auth');

Route::get('/conceptos', function () {
    return view('conceptos.index');
})->name('conceptos.index')->middleware('auth.admin');

Route::get('/cursos', function () {
    return view('cursos.index');
})->name('cursos.index')->middleware('auth.admin');

Route::get('/gestiones', function () {
    return view('gestiones.index');
})->name('gestiones.index')->middleware('auth.admin');

Route::get('/unegocios', function () {
    return view('unegocios.index');
})->name('unegocios.index')->middleware('auth');

Route::get('/estudiantes', function () {
    return view('estudiantes.index');
})->name('estudiantes.create')->middleware('auth');

Route::get('/planPagos', function () {
    return view('planPagos.index');
})->name('planPagos.index')->middleware('auth');

Route::get('/registros', function () {
    return view('registros.index');
})->name('registros.index')->middleware('auth');

Route::get('/transacciones', function () {
    return view('transacciones.index');
})->name('transacciones.index')->middleware('auth');

Route::get('/grupos', function () {
    return view('grupos.index');
})->name('grupos.index')->middleware('auth');


//reportes ***************************************
Route::get('/transacciones/reporte/{id}', [TransaccionController::class, 'reporte'])->name('transacciones.reporte');
//********* General */
Route::get('/reports', function () {
    return view('reports.index');
})->name('reports.index');   //$plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto
Route::get('/reports/rptGeneral_pdf/{idGes}/{idUNe}/{fIni}/{fFin}/{idTip}', [rptGeneralController::class, 'reporte'])->name('reports.rptGeneral_pdf');
//********** Por curso */
Route::get('/reports/indexXCurso', function () {
    return view('reports.indexXCurso');
})->name('reports.indexXCurso');   //$plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto {idGes}/{idUNe}/{fIni}/{fFin}/{idTip}
Route::get('/reports/rptXCurso_pdf/{idGes}/{idUNe}/{plGrupoID}', [rptXCursoController::class, 'reporte'])->name('reports.rptXCurso_pdf');

//****************** */
//Para proteger al acceso 
//Route::get('/admin', [AdminController::class, 'index'])
//    ->middleware('auth.admin')
//    ->name('conceptos.index');
//para proteger una accion de un controlador
Route::get('planPagos', 'PlanPagoController@show')->middleware('auth.admin');

Route::resource('estudiantes', EstudianteController::class)->middleware('auth.admin');
Route::resource('planPagos', PlanPagoController::class);
Route::resource('registros', RegistroController::class)->middleware('auth.admin');
Route::resource('transacciones', TransaccionController::class);
Route::resource('dtransacciones', DTransaccionController::class)->middleware('auth.admin');

Route::resource('conceptos', ConceptoController::class)->middleware('auth.admin');
Route::resource('dconceptos', DConceptoController::class)->middleware('auth.admin');
Route::resource('gestiones', GestionController::class)->middleware('auth.admin');
Route::resource('cursos', CursoController::class)->middleware('auth.admin');
Route::resource('unegocios', UNegocioController::class)->middleware('auth.admin');
Route::resource('grupos', GrupoController::class)->middleware('auth.admin');

Route::resource('valgrupos', ValGrupoController::class)->middleware('auth.admin');
Route::resource('valparametros', ValParametroController::class)->middleware('auth.admin');

// reportes ****************************************************************
Route::resource('reports', rptGeneralController::class);
Route::resource('reports/indexXCurso', rptXCursoController::class);

// fin reportes************************************************************
/* para determinar los tipos de conpceptos ingresos o egresos solo de esos tipos de TRANSACCIONES*/
Route::get('transacciones/conceptos/{id}/{idGes}/{idUNe}/tipo-transaccion', function ($id, $idGes, $idUne) {
    $cboConceptos = DB::select('call pDconceptos(0,null,null,?,?,?,6)', [$idGes, $id, $idUne]);
    return ($cboConceptos);
});
/*para detalle de costos */
Route::get('transacciones/DConceptos/{id}/{idR}/Det-Conceptos', function ($id, $idR) {
    $DConceptos = DB::select('call pDconceptos(?,?,null,null,null,null,5)', [$id, $idR]);
    return ($DConceptos);
});
/* para leer plan de pago del estudiante*/
Route::get('transacciones/ppagos/{id}/plan-pago', function ($id) {    
    try {
        $PlanPagos = DB::select('call pPlanPagos(?,null,null,null,null,null,null,null,null,9)', [$id]);        
        return ($PlanPagos);
        /*return response()->json($PlanPagos, 200);*/
    } catch (\Exception $e) {
        Log::error('Error al ejecutar la consulta: ' . $e->getMessage());
        return response()->json(['error' => 'Error al ejecutar la consulta', 'details' => $e->getMessage()], 500);
    }

});
/** Para guardar transaccion y detalle de transaccion  !!! IMportante¡¡¡¡¡*/
Route::get('transacciones/Transacciones/{tarray}/trans-dTrans', function ($tarray) {
    DB::select('call pTransacciones(0,null,null,null,null,null,1,null,null,null,?,1)',[$tarray]);
    return redirect()->route('transacciones.index')
                        ->with('success','Transaccion CREADO correctamente.');        
});
/** Para leer las UNEgocios del LOGIN */
route::get('login/{semail}/usuarios',function($semail){
    $cboUNegocios = DB::select('call pUsrUNegocios(0,null,null,?,6)',[$semail]);
    return ($cboUNegocios);
});

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::get('/home', function () {
    return view('home');
})->name('home')->middleware('auth');
