@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Lista de parametros:</h1>
<hr>
<div class="d-md-flex justify-content-md-end">
    <form action="{{ route('valparametros.index') }}" method="GET">
        <div class="btn-group">
            <!--<input type="text" name="busqueda" class="form-control">                      -->
            <select id="flGrupo_id" class="form-control" name="flGrupo_id">
                <option value="">-- Escoja el grupo --</option>
                @foreach ($valgrupos as $valgrupo )
                <option value="{{$valgrupo['lGrupo_id']}}">{{$valgrupo['sGrupo']}} </option>
                @endforeach
            </select>
            <input type="submit" value="Filtrar" class="btn btn-primary">
        </div>
    </form>
</div>
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('valparametros.create') }}"> Nuevo parametro</a>


        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
<!--<div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>-->
@endif
<table class="table table-hover table-sm">
    <thead class="table-dark">
        <tr>
            <th width="50px">Nro.</th>
            <th width="80px">Valor</th>
            <th width="80px">Parametro</th>
            <th width="80px">Grupo</th>
            <th width="80px">Estado</th>
            <th width="180px">Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($valparametro as $valparametros)
        <tr>
            <td>{{ $valparametros->lParametro_id }}</td>
            <td>{{ $valparametros->lValue_id }}</td>
            <td>{{ $valparametros->sParametro }}</td>
            <td>{{ $valparametros->lGrupo_id .' '. $valparametros->sGrupo }}</td>
            <td><?php if ($valparametros->boolEstado == 1) : ?>
                    <strong>Activa</strong>
                <?php else : ?>
                    <strong>No ACTIVA!!</strong>
                <?php endif ?>
            </td>
            <td>
                <?php if ($valparametros->boolEstado == 1) : ?>
                    <form action="{{ route('valparametros.destroy',$valparametros->lParametro_id) }}" method="POST">
                        <a class="btn btn-info" href="{{ route('valparametros.show',encrypt($valparametros->lParametro_id)) }}">Show</a>
                        <a class="fa fa-edit btn btn-primary" href="{{ route('valparametros.edit', encrypt($valparametros->lParametro_id)) }}">Editar</a>
                        @method('PUT')
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>No activo!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>

@endsection