@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
    <h1>Editar Parametros:</h1>
    <div class="row">
        <div class="col-lg-12 margin-tb">            
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('valparametros.index') }}"> Volver</a>
            </div>
        </div>
    </div>  

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Fallo!!</strong> Tenemos un problema en este momento.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif 
    <form action="{{ route('valparametros.update','valparametros') }}" method="POST">
        @csrf
        @method('put')
         <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Parametro ID:</strong>
                    <input readonly="True" type="text" name="lParametro_id" value="{{ $valparametro[0]->lParametro_id }}" class="form-control">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Grupo:</strong>
                    <!--<input type="text" name="lGrupo_id" value="{{ $valparametro[0]->lGrupo_id }}" class="form-control"> -->
                    <select id="lGrupo_id" class="form-control" name="lGrupo_id" >
                        <option value="" disabled>-- Escoja el grupo --</option>
                        @foreach ($valgrupos as $valgrupo )
                            <option value="{{$valgrupo['lGrupo_id']}}" <?php if($valgrupo->lGrupo_id == $valparametro[0]->lGrupo_id): ?> selected <?php else: ?> disabled <?php endif; ?> >{{$valgrupo['sGrupo']}} </option>    
                        @endforeach                        
                    </select>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Valor parametro:</strong>
                    <input readonly="True" type="text" name="lValue_id" value="{{ $valparametro[0]->lValue_id }}" class="form-control">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Descripcion Parametro:</strong>
                    <input type="text" name="sParametro" value="{{ $valparametro[0]->sParametro }}" class="form-control">
                </div>
            </div>
                        

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Activo..? </strong>                    
                    <input type="checkbox" name="boolEstado" <?php if($valparametro[0]->boolEstado==1): ?> checked <?php else: ?> unchecked <?php endif; ?> />
                </div>
            </div>
            
            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
              <button type="submit" class="btn btn-primary">Enviar</button>
            </div>
        </div>
    </form>
@endsection