@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
    <h1>Crear Parametros:</h1>
    <div class="row">
        <div class="col-lg-12 margin-tb">        
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('valparametros.index') }}"> Volver</a>
            </div>
        </div>
    </div> 
    @if ($errors->any())
    <div class="alert alert-danger">
        <strong>Falla!!</strong> Tenemos problemas al insertar datos.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <form action="{{ route('valparametros.store') }}" method="POST">
    @csrf
     <div class="row">        
     <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Grupo</strong>                
                <div class="form-group">
                    <select id="lGrupo_id" class="form-control" name="lGrupo_id">
                        <option value="">-- Escoja el grupo --</option>
                        @foreach ($valgrupos as $valgrupo )
                            <option value="{{$valgrupo['lGrupo_id']}}">{{$valgrupo['sGrupo']}}</option>    
                        @endforeach                        
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Parametro:</strong>
                <input type="text" class="form-control" name="sParametro" placeholder="Descripcion del parametro">
            </div>
        </div>       
        
        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                <button type="submit" class="btn btn-primary">Enviar</button>
        </div>
    </div>
    </form>
@endsection