@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Lista de Grupos:</h1>
<hr>

<form action="post">
    <label for="campo">Buscar</label>
    <input onkeypress="buscar($('#campo').val());" type="text" name="campo" id="campo">
</form>
<script>
    function buscar(buscar) {
        alert(buscar);
    }
</script>
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('valgrupos.create') }}"> Nuevo Grupo</a>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
@endif

<table class="table table-hover table-sm">
    <thead class="table-dark">
        <th width="50px">Nro.</th>
        <th width="80px">Grupo</th>
        <th width="180px">Action</th>
    </thead>
    @foreach ($valgrupos as $valgrupo)
    <tbody>
        <tr>
            <td>{{ $valgrupo->lGrupo_id }}</td>
            <td>{{ $valgrupo->sGrupo }}</td>
            <td>
                <form action="{{ route('valgrupos.destroy',$valgrupo->lGrupo_id) }}" method="POST">
                    <a class="btn btn-info" href="{{ route('valgrupos.show',encrypt($valgrupo->lGrupo_id)) }}">Show</a>
                    <a class="btn btn-primary" href="{{ route('valgrupos.edit', encrypt($valgrupo->lGrupo_id)) }}">Editar</a>
                    @method('PUT')
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Cerrar</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
{{$valgrupos->links()}}
@endsection