@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Unidades Educativas:</h1>
<!-- Mostrar la lista de negocios aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('unegocios.create') }}"> Nueva Unidad</a>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>

@endif
<table class="table table-hover table-sm">
    <thead class="table-dark">
        <tr>
            <th width="50px">Nro.</th>
            <th width="80px">Codigo</th>
            <th width="100px">Descripcion</th>
            <th width="80px">Estado</th>
            <th width="180px">Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($unegocios as $unegocio)
        <tr>
            <td>{{ $unegocio->lUNegocio_id }}</td>
            <td>{{ $unegocio->sCodigo }}</td>
            <td>{{ $unegocio->sDescripcion .' ('. $unegocio->sTurno.')' }}</td>
            <td><?php if ($unegocio->boolEstado == 1) : ?>
                    <strong>Activa</strong>
                <?php else : ?>
                    <strong>No ACTIVA!!</strong>
                <?php endif ?>
            </td>
            <td>
                <?php if ($unegocio->boolEstado == 1) : ?>
                    <form action="{{ route('unegocios.destroy',$unegocio->lUNegocio_id) }}" method="POST">
                        <a class="btn btn-info" href="{{ route('unegocios.show',encrypt($unegocio->lUNegocio_id)) }}">Show</a>
                        <a class="btn btn-primary" href="{{ route('unegocios.edit',encrypt($unegocio->lUNegocio_id)) }}">Editar</a>
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>Unidad No Activa!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection