@extends('adminlte::page')

@section('content')
<h1>Editar Unidad Educativa</h1>
<hr>
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-primary" href="{{ route('unegocios.index') }}"> Volver</a>
        </div>
    </div>
</div>

@if ($errors->any())
<div class="alert alert-danger">
    <strong>Fallo!!</strong> Tenemos un problema en este momento.<br><br>
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif
<form action="{{ route('unegocios.update','unegocio') }}" enctype="multipart/form-data" method="POST">
    @csrf
    @method('put')
    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Unidad ID:</strong>
                <input readonly="True" type="text" name="lUNegocio_id" value="{{ $unegocio->lUNegocio_id }}" class="form-control" placeholder="UNegocio ID">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Codigo:</strong>
                <input readonly="True" type="text" name="sCodigo" value="{{ $unegocio->sCodigo }}" class="form-control" placeholder="Codigo">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Descripción:</strong>
                <input type="text" class="form-control" name="sDescripcion" value= "{{ $unegocio->sDescripcion }}">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Turno Unidad:</strong>
                <div class="form-group">
                    <select id="lTurno" class="form-control" name="lTurno">
                        <option value="" disabled>-- Escoja Turno --</option>
                        @foreach ($cboTurnos as $lista )
                        <option value="{{$lista->lValue_id}}" <?php if ($lista->lValue_id == $unegocio->lTurno) : ?> selected <?php else : ?> ' ' <?php endif; ?>>{{$lista->sParametro}} </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Nivel:</strong>
                <div class="form-group">
                    <select id="lNivel" class="form-control" name="lNivel">
                        <option value="" disabled>-- Escoja Nivel --</option>
                        @foreach ($cboNiveles as $lista )
                        <option value="{{$lista->lValue_id}}" <?php if ($lista->lValue_id == $unegocio->lNivel) : ?> selected <?php else : ?> ' ' <?php endif; ?>>{{$lista->sParametro}} </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Ciudad:</strong>
                <div class="form-group">
                    <select id="lCiudad" class="form-control" name="lCiudad">
                        <option value="" disabled>-- Escoja ciudad --</option>
                        @foreach ($cboCiudades as $lista )
                        <option value="{{$lista->lValue_id}}" <?php if ($lista->lValue_id == $unegocio->lCiudad) : ?> selected <?php else : ?> ' ' <?php endif; ?>>{{$lista->sParametro}} </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Dirección:</strong>
                <input type="text" name="sDireccion" value="{{ $unegocio->sDireccion }}" class="form-control">
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Teléfono:</strong>
                <input type="text" name="sFono" value="{{ $unegocio->sFono }}" class="form-control">
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Logo:</strong>
                    <input hidden type="text" name="sFoto" value="{{ $unegocio->sLogo }}" class="form-control">
                    <input type="file" class="form-control" name="sLogo" value="{{$unegocio->sLogo}}">
                    <img src="/img/unegocio/{{$unegocio->sLogo}}" width="100px" alt="alt" class="img-circle img-thumbnail img-rounded">
                </div>
            </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Activo..? </strong>
                <input type="checkbox" name="boolEstado" <?php if ($unegocio->boolEstado == 1) : ?> checked <?php else : ?> unchecked <?php endif; ?> />
            </div>
        </div>        

        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="submit" class="btn btn-primary">Enviar</button>
        </div>
    </div>
</form>
@endsection