@extends('adminlte::page')

@section('content')
<h1>Crear Unidad de Negocio</h1>
<!-- Formulario para crear una nueva unidad de negocio aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-primary" href="{{ route('unegocios.index') }}"> Volver</a>
        </div>
    </div>
</div>
@if ($errors->any())
<div class="alert alert-danger">
    <strong>Falla!!</strong> Tenemos problemas al insertar datos.<br><br>
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif
<form action="{{ route('unegocios.store') }}" enctype="multipart/form-data" method="POST">
    @csrf
    <div class="row">
        <!--
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Codigo:</strong>
                <input type="text" name="sCodigo" class="form-control" placeholder="Codigo">
            </div>
        </div>-->
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Descripción:</strong>
                <textarea class="form-control" style="height:80px" name="sDescripcion" placeholder="Descripcion"></textarea>
            </div>
        </div>

        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <strong>Turno Unidad:</strong>
                <div class="form-group">
                    <select id="lTurno" class="form-control" name="lTurno">
                        <option value="">-- Escoja Turno --</option>
                        @foreach ($cboTurnos as $lista )
                        <option value="{{$lista->lValue_id}}">{{$lista->sParametro }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <strong>Nivel Unidad:</strong>
                <div class="form-group">
                    <select id="lNivel" class="form-control" name="lNivel">
                        <option value="">-- Escoja Nivel --</option>
                        @foreach ($cboNiveles as $lista )
                        <option value="{{$lista->lValue_id}}">{{$lista->sParametro }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <strong>Ciudad Unidad:</strong>
                <div class="form-group">
                    <select id="lCiudad" class="form-control" name="lCiudad">
                        <option value="">-- Escoja Ciudad --</option>
                        @foreach ($cboCiudades as $lista )
                        <option value="{{$lista->lValue_id}}">{{$lista->sParametro }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Dirección:</strong>
                <input type="text" class="form-control" name="sDireccion" placeholder="Dirección">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Teléfono:</strong>
                <input type="text" class="form-control" name="sFono" placeholder="Telefono">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Foto:</strong>
                <input type="file" class="form-control" name="sLogo" accept="image/png, .jpeg, .jpg, image/gif">
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="submit" class="btn btn-primary">Enviar</button>
        </div>
    </div>
</form>

@endsection