@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<h1> Transaccion</h1>
<hr>
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-primary" href="{{ route('transacciones.index') }}"> Back</a>            
            <a class="btn btn-info" href="{{ route('transacciones.reporte',encrypt($transacciones[0]->lTransaccion_id)) }}" target="_blank">Print</a>
        </div>    
    </div>
</div>

<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Numero de Transacción:</strong>
            {{ $transacciones[0]->lNroTransaccion }}
        </div>
    </div>
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Fecha:</strong>
            {{ date("d/m/Y", strtotime($transacciones[0]->dtTransaccion)) }}
        </div>
    </div>
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Comprobante de:</strong>
            {{ $transacciones[0]->sTipo }}
        </div>
    </div>
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Estado:</strong>
            {{ $transacciones[0]->sEstado }}
        </div>
    </div>
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Gestion:</strong>
            {{ $transacciones[0]->sGestion }}
        </div>
    </div>
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Unidad Educativa:</strong>
            {{ $transacciones[0]->sUNegocio }}
        </div>
    </div>
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Cliente:</strong>
            {{ $transacciones[0]->sCliente }}
        </div>
    </div>
    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <strong>Glosa:</strong>
            {{ $transacciones[0]->sGlosa }}
        </div>
    </div>

    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="form-group">
            <div class="container text-center">
                <div class="row border border-dark">
                    <div class="col-3 col-sm-3 bg-secondary text-white border-bottom"><strong>Codigo</strong></div>
                    <div class="col-3 col-sm-3 bg-secondary text-white border-bottom"><strong>Concepto</strong></div>
                    <div class="col-2 col-sm-2 bg-secondary text-white border-bottom"><strong>Monto</strong></div>
                    <div class="col-2 col-sm-2 bg-secondary text-white border-bottom"><strong>Cantidad</strong></div>
                    <div class="col-2 col-sm-2 bg-secondary text-white border-bottom"><strong>SubTotal</strong></div>

                    @foreach (json_decode($transacciones[0]->Detalle) as $detalle )
                    <div class="col-3 col-sm-3">{{$detalle->lDConcepto_id}}</div>
                    <div class="col-3 col-sm-3 text-left">{{$detalle->sConcepto}}</div>
                    <div class="col-2 col-sm-2">{{number_format($detalle->lMonto, 2)}}</div>
                    <div class="col-2 col-sm-2">{{$detalle->lCantidad}}</div>
                    <div class="col-2 col-sm-2">{{number_format($detalle->lSubTotal, 2)}}</div>
                    @endforeach
                </div>
                <div class="row">
                    <div class="col-3 col-sm-3"><strong></strong></div>
                    <div class="col-3 col-sm-3"><strong></strong></div>
                    <div class="col-2 col-sm-2"><strong></strong></div>
                    <div class="col-2 col-sm-2  text-right"><strong>TOTAL:</strong></div>
                    <div class="col-2 col-sm-2"><strong>{{ $transacciones[0]->lTotal }}</strong></div>
                </div>                
            </div>
        </div>

    </div>
</div>
@endsection