<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="{{ public_path('css/reporte.css') }}" type="text/css">
    <style>
               
    </style>
</head>

<body>

    <div id="header">
        <img class="imgHeader" src="{{public_path('/img/unegocio/')}}{{$unegocios[0]->sLogo}}" alt="Logo">
        <div class="header2">Unidad educativa: {{$unegocios[0]->sDescripcion}} </div>
        <div class="header2">Turno:{{$unegocios[0]->sTurno}} </div>
        <div class="header2">Fono: {{$unegocios[0]->sFono}} </div>
    </div>

    <hr>
    <div>
        <table>
            <tr>
                <td></td>
                <td class="text-right">
                    <div class="rounded"><strong>Nro. Transacción:</strong> {{ $transacciones[0]->lNroTransaccion }}</div>
                </td>
            </tr>
            <tr>
                <td><strong>Comprobante de:</strong> {{ $transacciones[0]->sTipo }}</td>
                <td class="text-right"><strong>Fecha:</strong> {{ date("d/m/Y", strtotime($transacciones[0]->dtTransaccion)) }}</td>
            </tr>
            <tr>
                <td><strong>Estado:</strong> {{ $transacciones[0]->sEstado }} </td>
                <td class="text-right"><strong>Gestion:</strong> {{ $transacciones[0]->sGestion }} </td>
            </tr>

            <tr>
                <td colspan="2"> <strong>Unidad Educativa:</strong> {{ $transacciones[0]->sUNegocio }} </td>
            </tr>
            <tr>
                <td colspan="2"> <strong>Cliente:</strong> {{ $transacciones[0]->sCliente }}</td>
            </tr>
            <tr>
                <td colspan="2"> <strong>Glosa:</strong> {{ $transacciones[0]->sGlosa }}</td>
            </tr>

        </table>
    </div>
    <hr>
    <br>

    <table class="table border text-center">
        <thead>
            <tr>
                <th><strong>Codigo</strong></th>
                <th><strong>Concepto</strong></th>
                <th><strong>Monto</strong></th>
                <th><strong>Cantidad</strong></th>
                <th><strong>SubTotal</strong></th>
            </tr>
        </thead>
        <tbody>
            @foreach (json_decode($transacciones[0]->Detalle) as $detalle )
            <tr class="border">
                <td>{{$detalle->lDConcepto_id}}</td>
                <td class="text-left">{{$detalle->sConcepto}}</td>
                <td>{{number_format($detalle->lMonto, 2)}}</td>
                <td>{{$detalle->lCantidad}}</td>
                <td>{{number_format($detalle->lSubTotal, 2)}}</td>
            </tr>
            @endforeach
            <tr>

                <td><strong></strong></td>
                <td><strong></strong></td>
                <td><strong></strong></td>
                <td class="text-right"><strong>TOTAL:</strong></td>
                <td><strong>{{ $transacciones[0]->lTotal }}</strong></td>

            </tr>
        </tbody>
    </table>

    <div id="footer">
        <hr>
        <p class="textfooter"> Dirección: {{$unegocios[0]->sDireccion}} {{$unegocios[0]->sCiudad}} - Bolivia </p>
    </div>

</body>

</html>