@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Transacciones</h1>
<hr>

<!-- Mostrar la lista de transacciones aquí -->
<div class="row">
    <div class="col margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('transacciones.create') }}"> Nueva transacción</a>
        </div>
    </div>
    <div class="col margin-tb">
        <div class="d-md-flex justify-content-md-end">
            <form action="{{ route('transacciones.index') }}" method="GET">
                <div class="btn-group">
                    <input type="number" min="1" name="flNroTransaccion" class="form-control" placeholder="Nro de transacción">
                    <input type="submit" value="Filtrar" class="btn btn-primary">
                </div>
            </form>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
@endif
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">ID</th>
                <th width="80px">Nro. Trans.</th>
                <th width="80px">Fecha</th>
                <th width="80px">Tipo</th>
                <th width="80px">Cliente</th>
                <th width="80px">Total</th>
                <th width="80px">Estado</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        @foreach ($transacciones as $transaccion)
        <tbody>
            <tr>
                <td>{{ $transaccion->lTransaccion_id }}</td>
                <td>{{ $transaccion->lNroTransaccion }}</td>
                <td>{{ date("d/m/Y", strtotime($transaccion->dtTransaccion)) }}</td>
                <td>{{ $transaccion->sTipo }}</td>
                <td>{{ $transaccion->sCliente }}</td>
                <td>{{ $transaccion->lTotal }}</td>
                <td>{{ $transaccion->sEstado }}</td>

                <td>
                    <?php if ($transaccion->lEstado == 1) : ?>
                        <form id="anularForm" action="{{ route('transacciones.destroy', $transaccion->lTransaccion_id) }}" method="POST">
                            <a class="btn btn-info" href="{{ route('transacciones.show', encrypt($transaccion->lTransaccion_id)) }}">Show</a>
                            @method('PUT')
                            @csrf
                            @method('DELETE')
                            <button type="button" id="confirmAnular" class="btn btn-danger">Anular</button>
                        </form>
                    <?php else : ?>
                        <strong>Anulado!!</strong>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
        @endforeach
    </table>
</div>
<script>
    document.getElementById('confirmAnular').addEventListener('click', function() {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¿Quiere anular esta transacción?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sí, anular',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('anularForm').submit();
            }
        });
    });
</script>
@endsection
