@extends('adminlte::page')
<style>
.mesespagados {
    display: flex;
    justify-content: left;
}

.elemento {
    margin-right: 10px;
}
</style>
@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Formulario para crear una nueva transacción aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-primary" href="{{ route('transacciones.index') }}"> Volver</a>
        </div>
    </div>
</div>
@if ($errors->any())
<div class="alert alert-danger">
    <strong>Falla!!</strong> Tenemos problemas al insertar datos.<br><br>
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif
<?php
$GestionID = (int)session('GestionID'); //  1; //$_SESSION['GestionID'];
$UNegocioID = (int)session('UNegocioID');
?>

<div class="row">
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div>
            <strong>Gestión Academica:</strong>
            <div>
                <select id="lGestion_id"  name="lGestion_id" class="form-control">
                    <option value="" disabled >-- Escoja Gestión --</option>
                    @foreach ($cboGestiones as $lista )
                    <option value="{{$lista->lGestion_id}}" <?php if ($lista->lGestion_id == $GestionID) : ?> selected
                        <?php else : ?> disabled <?php endif; ?>>{{$lista->sGestion}}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class="col-xs-4 col-sm-4 col-md-4">
        <div>
            <strong>Unidad Educativa:</strong>
            <div>
                <select id="lUNegocio_id" name="lUNegocio_id" class="form-control">
                    <option value="" disabled>-- Escoja Unidad --</option>
                    @foreach ($cboUNegocios as $lista )
                    <option value="{{$lista->lUNegocio_id}}" <?php if ($lista->lUNegocio_id == $UNegocioID) : ?>
                        selected <?php else : ?> disabled <?php endif; ?>>{{$lista->sDescripcion }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>    
</div>

<div class="row">
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>RFI-ID:</strong>
            <div class="form-group">
                <form action="{{ route('transacciones.create') }}" method="GET">
                    <div class="btn-group">
                        <input type="text" name="rfid" id="rfid" class="form-control" placeholder="RFI-ID">
                        <button id="btnBuscar" name="btnBuscar" class="btn add-btn btn-secondary">                            
                            <i class="bi bi-search"></i>
                        </button>

                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Estudiante:</strong>
            <div class="form-group">
                <select id="lRegistro_id" onchange="loadValues(this)" class="form-control" name="lRegistro_id">
                    <option value="">-- Escoja Estudiante --</option>
                    @foreach ($cboRegistros as $lista )
                    <option value="{{$lista->lRegistro_id}}">{{$lista->sEstudiante .' '. $lista->sCurso}}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

</div>
<div class="form-group ">
    <label class="elemento" for="p1"> Feb </label><input class="elemento" type="checkbox" id="p1" name="p1" disabled>
    <label class="elemento" for="p2"> Mar </label><input class="elemento" type="checkbox" id="p2" name="p2" disabled>
    <label class="elemento" for="p3"> Abr </label><input class="elemento" type="checkbox" id="p3" name="p3" disabled>
    <label class="elemento" for="p4"> May </label><input class="elemento" type="checkbox" id="p4" name="p4" disabled>
    <label class="elemento" for="p5"> Jun </label><input class="elemento" type="checkbox" id="p5" name="p5" disabled>
    <label class="elemento" for="p6"> Jul </label><input class="elemento" type="checkbox" id="p6" name="p6" disabled>
    <label class="elemento" for="p7"> Ago </label><input class="elemento" type="checkbox" id="p7" name="p7" disabled>
    <label class="elemento" for="p8"> Sep </label><input class="elemento" type="checkbox" id="p8" name="p8" disabled>
    <label class="elemento" for="p9"> Oct </label><input class="elemento" type="checkbox" id="p9" name="p9" disabled>
    <label class="elemento" for="p10"> Nov </label><input class="elemento" type="checkbox" id="p10" name="p10" disabled>
    <input type="text" name="cant" id="cant" disabled hidden>
</div>
<form action="{{ route('transacciones.store') }}" method="POST" name="frmCabecera" id="frmCabecera">
    @csrf
    <div class="row">
        <div class="col-xs-8 col-sm-8 col-md-8">
            <div class="form-group">
                <strong>Glosa:</strong>
                <input type="text" class="form-control" name="sGlosa" placeholder="Glosa de la transaccion">
            </div>
        </div>
    </div>
    <div class="row">    
        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Tipo Transacción:</strong>
                <div class="form-group">
                    <select id="lTipo" onchange="loadConceptos(this)"
                        class="form-control w-full bg-white rounded shadow" name="lTipo">
                        <option value="" selected>-- Tipo Movimiento --</option>
                        @foreach ($cboTipoTransacciones as $lista )
                        <option value="{{$lista->lValue_id}}" <?php if ($lista->lValue_id == 1) : ?> ' '
                            <?php else : ?> ' ' <?php endif; ?>> {{$lista->sParametro }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Cliente:</strong>
                <input type="text" class="form-control" name="sCliente" id="sCliente" placeholder="Nombre del cliente">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xs-3 col-sm-3 col-md-3">
            <div class="form-group">
                <strong>Conceptos:</strong>
                <div class="form-group">
                    <select id="lDConcepto_id" onchange="loadPrecios(this)" class="form-control" name="lDConcepto_id">
                        <option value="">-- Escoja Concepto --</option>
                        @foreach ($cboConceptos as $lista )
                        <option value="{{$lista->lDConcepto_id}}">{{$lista->sConcepto }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-2 col-sm-2 col-md-2">
            <div class="form-group">
                <strong>Monto:</strong>
                <input type="number" class="form-control" id="lMonto" name="lMonto" value="0" placeholder="Monto"
                    min="1" step="1" require>
            </div>
        </div>
        <div class="col-xs-2 col-sm-2 col-md-2">
            <div class="form-group">
                <strong>Cantidad:</strong>
                <input type="number" class="form-control" id="lCantidad" name="lCantidad" value="1" placeholder="Cantidad" min="1"
                    max="5" require>
            </div>
        </div>
        <div class="col-xs-2 col-sm-2 col-md-2">
            <div class="form-group">
                <br>
                <button id="botonDeEnvio" name="botonDeEnvio" class="btn add-btn btn-info">
                    <i class="bi bi-plus-circle"></i>
                </button>
            </div>
        </div>
    </div>
</form>
<div class="table-responsive-sm">
    <table class="table table-hover table-sm" id="transactionTable" name="transactionTable">
        <thead class="table-dark">
            <tr>
                <th width="50px">ID</th>
                <th width="80px">Concepto</th>
                <th width="80px">Monto</th>
                <th width="80px">Cantidad</th>
                <th width="80px">Sub Total</th>
                <th width="80px">Action</th>
            </tr>
        </thead>

        <tbody>
            <tr>
                <td> </td>
                <td> </td>
                <td> </td>
                <td> <strong>Total:</strong> </td>
                <td>
                    <input type="text" class="form-control" id="lTotal" name="lTotal" value="0" readonly="true">
                </td>
                <td>
                    <div name="boton" id="boton"></div>
                </td>
            </tr>
        </tbody>
    </table>
    <hr>
</div>

<div class="col-xs-12 col-sm-12 col-md-12 text-center">
    <button id="btnEnviar" name="btnEnviar" onclick="guardarDatos(this)" type="submit"
        class="btn btn-primary">Enviar</button>
</div>

<script>
// para seleccionar solo conceptos de acuerdo a un tipo Ingreso o Egreso
function loadConceptos(TipoTransaccion) {
    let tTransaccion = TipoTransaccion.value;
    let plGestionID = document.getElementById('lGestion_id').value; // 1;
    let plUNegocioID = document.getElementById('lUNegocio_id').value;
    fetch(`conceptos/${tTransaccion}/${plGestionID}/${plUNegocioID}/tipo-transaccion`)
        .then(response => response.json())
        .then(jsonData => builConceptosSelect(jsonData))
    //console.log(JSON.stringify(jsonData));                                
}

function builConceptosSelect(jsonConceptos) {
    let conceptosSelect = document.getElementById('lDConcepto_id');
    clearSelect(conceptosSelect);
    jsonConceptos.forEach(concepto => {
        let optionTag = document.createElement('option');
        optionTag.value = concepto.lDConcepto_id;
        optionTag.innerHTML = concepto.sConcepto;
        conceptosSelect.append(optionTag);
    })
}

function clearSelect(select) {
    while (select.options.length > 1) {
        select.remove(1);
    }
}
//fin de seleccion de conceptos.
//para cargar nombre de estudiante al cliente y generar glosa y datos plan pagos
function loadValues(pEstudiante) {
    /* Para obtener el texto */
    var texto = pEstudiante.options[pEstudiante.selectedIndex].text;
    //console.log(texto); format(date, 'dd/MM/yyyy'); + 
    var tDate = new Date().toLocaleDateString().replace('/', '-');
    document.frmCabecera.sCliente.value = texto;
    document.frmCabecera.sGlosa.value = tDate.replace('/', '-') + ' ' + texto;
    //aqui empieza la lectura de valores PP http://127.0.0.1:8000/transacciones/ppagos/1/plan-pago
    var idPlanPago = pEstudiante.options[pEstudiante.selectedIndex].value; //recuperamos el id estudiante plan de pago
    //console.log(idPlanPago);
    fetch(`ppagos/${idPlanPago}/plan-pago`)
        .then(response => response.json())
        .then(jsonData => buildPpagos(jsonData))
}

function buildPpagos(jsonPpagos) 
{
    //let NroPagos = 2;
    var _p1 = document.getElementById('p1');
    var _p2 = document.getElementById('p2');
    var _p3 = document.getElementById('p3');
    var _p4 = document.getElementById('p4');
    var _p5 = document.getElementById('p5');
    var _p6 = document.getElementById('p6');
    var _p7 = document.getElementById('p7');
    var _p8 = document.getElementById('p8');
    var _p9 = document.getElementById('p9');
    var _p10 = document.getElementById('p10');
    var _cant = document.getElementById('cant');
    
    
    jsonPpagos.forEach(ppagos => {
        _p1.checked = !(ppagos.p1 > 0);
        _p2.checked = !(ppagos.p2 > 0);
        _p3.checked = !(ppagos.p3 > 0);
        _p4.checked = !(ppagos.p4 > 0);
        _p5.checked = !(ppagos.p5 > 0);
        _p6.checked = !(ppagos.p6 > 0);
        _p7.checked = !(ppagos.p7 > 0);
        _p8.checked = !(ppagos.p8 > 0);
        _p9.checked = !(ppagos.p9 > 0);
        _p10.checked = !(ppagos.p10 > 0);
        _cant.value = ppagos.cant;               
 
    })
}
// fin asignacion de valores cliente y GLOSA 
function loadPrecios(pDConcepto) {
    let lDConceptoID = pDConcepto.value;
    let lRegistroID = document.getElementById('lRegistro_id').value;

    fetch(`DConceptos/${lDConceptoID}/${lRegistroID}/Det-Conceptos`)
        .then(response => response.json())
        .then(jsonData => loadMontos(jsonData))
    // console.log(JSON.stringify(jsonData)))
}

function loadMontos(jsonValores) {
    var plMonto = jsonValores[0].lMonto;
    var plTipo = jsonValores[0].lTipoDConcepto;
    document.frmCabecera.lMonto.value = plMonto;
    if (plTipo == 1) document.frmCabecera.lMonto.readOnly = true;
    else document.frmCabecera.lMonto.readOnly = false;
    //Para controla las cantidades a pagar de aportes
    var _lcantidad = document.getElementById('lCantidad');
    var _cant = document.getElementById('cant');
    var plConceptoID = jsonValores[0].lConcepto_id;
    if (plConceptoID == 1) _lcantidad.max = _cant.value;
    else _lcantidad.max = 10;
}
const form = document.getElementById('frmCabecera');
const btnEnviar = document.querySelector('btnEnviar');

form.addEventListener("submit", function(event) {
    event.preventDefault();
    const form = document.getElementById('frmCabecera');
    addRow()
})
//Funcion para insertar una fila a la tabla
function addRow() {
    let transactionFormData = new FormData(form);
    
    if (transactionFormData.get("lMonto") > 0 && transactionFormData.get("lDConcepto_id") > 0) {
        let transactionTableRef = document.getElementById('transactionTable');
        let newTransactionRowRef = transactionTableRef.insertRow(1); //Insertando fila
        //Insertando Celdas a la fila adicionado
        let newTransactionCellRef = newTransactionRowRef.insertCell(0);
        newTransactionCellRef.textContent = transactionFormData.get("lDConcepto_id");
        newTransactionCellRef = newTransactionRowRef.insertCell(1);
        let pConcepto = document.getElementById('lDConcepto_id');
        var texto = pConcepto.options[pConcepto.selectedIndex].text;        
        newTransactionCellRef.textContent = texto;
        newTransactionCellRef = newTransactionRowRef.insertCell(2);
        newTransactionCellRef.textContent = transactionFormData.get("lMonto");
        newTransactionCellRef = newTransactionRowRef.insertCell(3);
        newTransactionCellRef.textContent = transactionFormData.get("lCantidad");
        newTransactionCellRef = newTransactionRowRef.insertCell(4);
        newTransactionCellRef.textContent = transactionFormData.get("lMonto") * transactionFormData.get("lCantidad");

        newTransactionCellRef = newTransactionRowRef.insertCell(5);
        newTransactionCellRef.innerHTML =
            `<button id="btnQuitar" onclick="QuitarFila(this)" class="btn add-btn btn-danger"><i class="bi bi-x-octagon"></i></button>`;
        lTotal.value = parseInt(lTotal.value) + (transactionFormData.get("lMonto") * transactionFormData.get(
            "lCantidad"));
        document.frmCabecera.lCantidad.value = "1";
        //Para controlar la cantidad de pagos tipo aportes
        if (parseInt(texto.split("-")[0])==1){
            var _lcantidad = document.getElementById('lCantidad');
            var _cant = document.getElementById('cant');
            _cant.value = _cant.value - transactionFormData.get("lCantidad");
            _lcantidad.max = _cant.value;
        }

    } else {
        Swal.fire('Alerta', 'El Monto debe ser mayor a "0" \n o elija el concepto', 'error')
    }
}
//Funcion para quitar una fila de la tabla
function QuitarFila(Id) {
    let row = Id.parentNode.parentNode;
    let table = document.getElementById("transactionTable");
    //console.log (row.cells[4].textContent);
    lTotal.value = parseInt(lTotal.value) - parseInt(row.cells[4].textContent);
    table.deleteRow(row.rowIndex);
     //Para controlar la cantidad de pagos tipo aportes
    if (parseInt((row.cells[1].textContent).split("-")[0])==1){
        var _lcantidad = document.getElementById('lCantidad');
        var _cant = document.getElementById('cant');
        _cant.value = parseInt(_cant.value) + parseInt(row.cells[3].textContent);
        _lcantidad.max = _cant.value;
    }
}
// Funcion para guardar datos del detalle !!Importante¡¡¡¡
function guardarDatos(id) {
    if (lTotal.value > 0) {
        var trans = [];                
        trans[0] = (document.frmCabecera.lTipo.value);
        trans[1] = (document.frmCabecera.sCliente.value);
        trans[2] = (lTotal.value);
        trans[3] = (document.getElementById('lRegistro_id').value);
        trans[4] = (document.getElementById('lGestion_id').value);
        trans[5] = (document.getElementById('lUNegocio_id').value);
        trans[6] = (document.frmCabecera.sGlosa.value);

        var resume_table = document.getElementById("transactionTable");
        var filas = resume_table.rows.length;
        var colums = resume_table.rows[0].cells.length;
        var text = [];
        var dTrans = [];
        for (var f = 1; f < filas - 1; f++) {
            for (var c = 0; c < colums - 1; c++) {
                text[c] = (resume_table.rows[f].cells[c].innerText);
            }
            dTrans[f - 1] = text;
            text = [];
        }
        var transaccion = [trans, dTrans];
        fetch(`Transacciones/${transaccion}/trans-dTrans`)
            .then(response => window.open("../transacciones", "_self"))
        //window.open("../transacciones", "_self");
    } else {
        Swal.fire('Alerta', 'El total debe ser mayor a "0"', 'error')
    }
}
</script>
@endsection