@extends('reports.header')

@section('content')

@if(isset($data[0]->sTipo))
<h3 class="text-center">Reporte de <strong>{{ $data[0]->sTipo }}</strong> del <strong> {{$pFInicial}} </strong> al <strong>{{$pFFinal}}</strong></h3>
<h3 class="text-center">Gestion: <strong>{{ $data[0]->sGestion }}</strong></h3>
<table class="table border text-center">
    <thead>
        <tr>
            <th>Nro. Trans.</th>
            <th>Fecha</th>
            <th>Detalle</th>
            <th>Total</th>
            <th>Estado</th>
        </tr>
    </thead>
    <tbody>
        @foreach($data as $row)
        <tr class="border header2" <?php if ($row->lEstado == 2) echo 'style="background-color: yellow"'; ?>>
            <td>{{ $row->lNroTransaccion }}</td>
            <td>{{ date("d/m/Y", strtotime($row->dtTransaccion)) }}</td>
            <td>{{ $row->sCliente }}</td>
            <td>{{ $row->lTotal }}</td>
            <td>{{ $row->sEstado }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
<hr>
<table>
    <tbody class="border">
        <tr>
            <td colspan="3"><strong>TOTALES: </strong></td>
        </tr>
        @foreach ($totales as $row )
        <tr class="header2">
            <td></td>
            <td>{{ $row->sEstado }}</td>
            <td>{{ $row->lTotal }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
<hr>
@else
<h3 class="text-center">El reporte de <strong> {{$pFInicial}} </strong> al <strong>{{$pFFinal}}</strong></h3>
<p>El reporte no contiene datos</p>
@endif
@endsection