@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Reporte por curso..</h1>
<hr>
<?php
$GestionID = (int)session('GestionID'); //  1; //$_SESSION['GestionID'];
$UNegocioID = (int)session('UNegocioID');
?>

<div class="row">
    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Gestión Academica:</strong>
            <div class="form-group">
                <select id="lGestion_id" class="form-control" name="lGestion_id">
                    <option value="" disabled>-- Escoja Gestión --</option>
                    @foreach ($cboGestiones as $lista )
                    <option value="{{$lista->lGestion_id}}" <?php if ($lista->lGestion_id == $GestionID) : ?> selected <?php else : ?> disabled <?php endif; ?>>{{$lista->sGestion}}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Unidad Educativa:</strong>
            <div class="form-group">
                <select id="lUNegocio_id" class="form-control" name="lUNegocio_id">
                    <option value="" disabled>-- Escoja Unidad --</option>
                    @foreach ($cboUNegocios as $lista )
                    <option value="{{$lista->lUNegocio_id}}" <?php if ($lista->lUNegocio_id == $UNegocioID) : ?> selected <?php else : ?> disabled <?php endif; ?>>{{$lista->sDescripcion }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class="col-xs-4 col-sm-4 col-md-4">
        <div class="form-group">
            <strong>Curso Grupo:</strong>
            <div class="form-group">
                <select id="lGrupo_id" class="form-control" name="lGrupo_id">
                    <option value="">-- Escoja Curso --</option>
                    @foreach ($cboGrupos as $lista )
                    <option value="{{$lista->lGrupo_id}}">
                        {{$lista->sCurso.' '.$lista->sGrupo.' '.$lista->sNivel.' ('.$lista->lActual.')'}}
                    </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-info" href="" onclick="generarReporte()" target="_blank">Print</a>
        </div>
    </div>
</div>


@endsection
<script>
    function generarReporte() {
        // Obtener el valor seleccionado del <select> onclick="generarReporte()"
        var lGestionID = document.getElementById('lGestion_id').value;
        var lUNegocioID = document.getElementById('lUNegocio_id').value;
        var lGrupoID = document.getElementById('lGrupo_id').value;

        // Construir la URL de la ruta del reporte con el valor seleccionado como parámetro        
        var url = "{{route('reports.rptXCurso_pdf',[':lGestionID', ':lUNegocioID', ':lGrupoID']) }}";
        url = url.replace(':lGestionID', lGestionID)
            .replace(':lUNegocioID', lUNegocioID)
            .replace(':lGrupoID', lGrupoID);

        // Redireccionar a la URL construida
        window.location.href = url;
    }
</script>