@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Registros</h1>
<hr>
<!-- Mostrar la lista de registros aquí -->
<div class="row">
    <div class="col-lg-6 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('registros.create') }}"> Nuevo Registro</a>
        </div>
    </div>
    <div class="col margin-tb">
        <div class="d-md-flex justify-content-md-end">
            <form action="{{ route('registros.index') }}" method="GET">
                <div class="btn-group">
                    <input type="text" name="flBuscar" class="form-control" placeholder="Valor a buscar">
                    <input type="submit" value="Filtrar" class="btn btn-primary">
                </div>
            </form>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
@endif
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">Nro.</th>
                <th width="80px">Fecha</th>
                <th width="80px">Estudiante</th>
                <th width="80px">Grupo</th>
                <th width="80px">Gestion</th>
                <th width="80px">Estado</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        @foreach ($registros as $registro)
        <tbody>
            <tr>
                <td>{{ $registro->lRegistro_id }}</td>
                <td>{{ date("d/m/Y", strtotime($registro->dtRegistro)) }}</td>
                <td>{{ $registro->sEstudiante }}</td>
                <td>{{ $registro->sCurso }}</td>
                <td>{{ $registro->sGestion }}</td>

                <td><?php if ($registro->boolEstado == 1) : ?>
                        <strong>Confirmado</strong>
                    <?php else : ?>
                        <strong>Anulado</strong>
                    <?php endif ?>
                </td>
                <td>
                    <?php if ($registro->boolEstado == 1) : ?>
                        <form action="{{ route('registros.destroy',$registro->lRegistro_id) }}" method="POST">
                            <!--<a class="btn btn-info" href="{{ route('registros.show',encrypt($registro->lRegistro_id)) }}">Show</a>
                            <a class="btn btn-primary" href="{{ route('registros.edit', encrypt($registro->lRegistro_id)) }}">Editar</a>
                    -->
                            @method('PUT')
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Anular</button>
                        </form>
                    <?php else : ?>
                        <strong>No activo!!</strong>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
        @endforeach
    </table>
    <hr>
</div>
@endsection