@extends('adminlte::page')

@section('content')
<h1>Crear Registro</h1>
<hr>
<!-- Formulario para crear un nuevo registro aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-primary" href="{{ route('registros.index') }}"> Volver</a>
        </div>
    </div>
</div>
@if ($errors->any())
<div class="alert alert-danger">
    <strong>Falla!!</strong> Tenemos problemas al insertar datos.<br><br>
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif
<form action="{{ route('registros.store') }}" method="POST">
    @csrf
    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Gestión Academica:</strong>

                <div class="form-group">
                    <select id="lGestion_id" class="form-control" name="lGestion_id">
                        @foreach ($cboGestiones as $lista )
                        <option value="{{$lista->lGestion_id}}">{{$lista->sGestion}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Estudiante:</strong>

                <div class="form-group">
                    <select id="lEstudiante_id" class="form-control" name="lEstudiante_id">
                        <option value="">-- Escoja Estudiante --</option>
                        @foreach ($cboEstudiantes as $lista )
                        <option value="{{$lista->lEstudiante_id}}">{{$lista->sApellido.' '.$lista->sNombre}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Curso Grupo:</strong>

                <div class="form-group">
                    <select id="lGrupo_id" class="form-control" name="lGrupo_id">
                        <option value="">-- Escoja Curso --</option>
                        @foreach ($cboGrupos as $lista )
                        <option value="{{$lista->lGrupo_id}}">{{$lista->sCurso.' '.$lista->sGrupo.' '.$lista->sNivel.' ('.$lista->lActual.')'}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="submit" class="btn btn-primary">Enviar</button>
        </div>
    </div>
</form>
@endsection