@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Planes de Pagos</h1>
<hr>
<!-- Mostrar la lista de planes de pagos aquí -->
<div class="row">
    <div class="col-lg-6 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('planPagos.create') }}"> Nuevo Registro</a>
        </div>
    </div>
    <div class="col margin-tb">
        <div class="d-md-flex justify-content-md-end">
            <form action="{{ route('planPagos.index') }}" method="GET">
                <div class="btn-group">
                    <input type="text" name="flBuscar" class="form-control" placeholder="Valor a buscar">
                    <input type="submit" value="Filtrar" class="btn btn-primary">
                </div>
            </form>
        </div>
    </div> 
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
@endif
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">Nro.</th>
                <th width="80px">Gestion</th>
                <th width="80px">Unidad Educativa</th>
                <th width="80px">Estudiante</th>
                <th width="80px">Monto</th>
                <th width="80px">Saldo</th>
                <th width="80px">Pagado</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        @foreach ($planpagos as $planpago)
        <tbody>
            <tr>
                <td>{{ $planpago->lRegistro_id }}</td>
                <td>{{ $planpago->sGestion }}</td>
                <td>{{ $planpago->sDescripcion }}</td>
                <td>{{ $planpago->sEstudiante }}</td>
                <td>{{ $planpago->lMonto }}</td>
                <td>{{ $planpago->lDeuda }}</td>
                <td>{{ $planpago->lPagado }}</td>

                <td>
                    <?php if ($planpago->lDeuda > 0) : ?>
                        <form action="{{ route('planPagos.destroy',$planpago->lRegistro_id) }}" method="POST">
                            <a class="btn btn-info" href="{{ route('planPagos.show',encrypt($planpago->lRegistro_id)) }}" target="_blank"> show </a>
                            <!--<a class="far fa-edit btn btn-primary" href="{{ route('planPagos.edit', encrypt($planpago->lRegistro_id)) }}"> </a>-->
                            @method('PUT')
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn"></button>
                        </form>
                    <?php else : ?>
                        <strong>Pagado!!</strong>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
        @endforeach
    </table>
    <hr>
</div>
@endsection