@extends('adminlte::page')


@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de grupos ofertados</h1>
<hr>
<!-- Mostrar la lista de estudiantes aquí -->
<div class="d-md-flex justify-content-md-end">
    <form action="{{ route('grupos.index') }}" method="GET">
        <div class="btn-group">
            <!--<input type="text" name="busqueda" class="form-control">                      -->
            <select id="flNivel" class="form-control" name="flNivel">
                <option value="">-- Escoja Nivel del curso --</option>
                @foreach ($combobox as $lista )
                <option value="{{$lista->lValue_id}}">{{$lista->sParametro}} </option>
                @endforeach
            </select>
            <input type="submit" value="Filtrar" class="btn btn-primary">
        </div>
    </form>
</div>
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('grupos.create') }}"> Nuevo grupo</a>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
@endif
<table class="table table-hover table-sm">
    <thead class="table-dark">
        <thead>
            <tr>
                <th width="30px">Nro.</th>
                <th width="80px">U. Educativa</th>
                <th width="80px">Curso</th>
                <th width="20px">Grupo</th>
                <th width="60px">Gestion</th>
                <th width="60px">Minimo</th>
                <th width="60px">Máximo</th>
                <th width="60px">Actual</th>                
                <th width="80px">Estado</th>
                <th width="80px">Nivel</th>                
                <th width="180px">Action</th>
            </tr>
        </thead>
        @foreach ($grupos as $grupo)
    <tbody>
        <tr>
            <td>{{ $grupo->lGrupo_id }}</td>
            <td>{{ $grupo->sDescripcion }}</td>
            <td>{{ $grupo->lCurso_id .'-'. $grupo->sCurso }}</td>
            <td>{{ $grupo->sGrupo }}</td>
            <td>{{ $grupo->sGestion }}</td>
            <td>{{ $grupo->lMinimo }}</td>
            <td>{{ $grupo->lMaximo }}</td>
            <td>{{ $grupo->lActual }}</td>            
            <td>{{ $grupo->sParametro }}</td>
            <td>{{ $grupo->sNivel }}</td>
            

            <td>
                <?php if ($grupo->boolEstado == 1 or $grupo->boolEstado == 3) : ?>
                    <form action="{{ route('grupos.destroy',$grupo->lGrupo_id) }}" method="POST">
                        <a class="btn btn-info" href="{{ route('grupos.show',encrypt($grupo->lGrupo_id)) }}">Show</a>
                        <a class="btn btn-primary" href="{{ route('grupos.edit', encrypt($grupo->lGrupo_id)) }}">Editar</a>
                        @method('PUT')
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>No activo!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection