@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
    <h1>Editar Conceptos</h1> <hr>
    <!-- Mostrar la lista de Grupos aquí -->
    <div class="row">
        <div class="col-lg-12 margin-tb">            
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('grupos.index') }}"> Volver</a>
            </div>
        </div>
    </div>  

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Fallo!!</strong> Tenemos un problema en este momento.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif 
    <form action="{{ route('grupos.update','grupos') }}" method="POST">
        @csrf
        @method('put')
         <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Grupo ID:</strong>
                    <input readonly="True" type="text" name="lGrupo_id" value="{{ $grupos->lGrupo_id }}" class="form-control">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Gestión:</strong>                
                    <div class="form-group">
                        <select id="lGestion_id" class="form-control" name="lGestion_id">
                            <option value="" disabled>-- Escoja la gestión --</option>
                            @foreach ($cboGestiones as $lista )
                                <option value="{{$lista->lGestion_id}}" <?php if($lista->lGestion_id == $grupos->lGestion_id): ?> selected <?php else: ?> disabled <?php endif; ?> >{{$lista->sGestion}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>
       
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Unidad Educativa:</strong>                
                    <div class="form-group">
                        <select id="lUNegocio_id" class="form-control" name="lUNegocio_id">
                            <option value="" disabled>-- Escoja la unidad educativa --</option>
                            @foreach ($cboUNegocios as $lista )
                                <option value="{{$lista->lUNegocio_id}}" <?php if($lista->lUNegocio_id == $grupos->lUNegocio_id): ?> selected <?php else: ?> disabled <?php endif; ?> >{{$lista->sDescripcion}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Curso:</strong>                
                    <div class="form-group">
                        <select id="lCurso_id" class="form-control" name="lCurso_id">
                            <option value="" disabled>-- Escoja el curso --</option>
                            @foreach ($cboCursos as $lista )
                                <option value="{{$lista->lCurso_id}}" <?php if($lista->lCurso_id == $grupos->lCurso_id): ?> selected <?php else: ?> disabled <?php endif; ?>>{{$lista->sCurso}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Nivel del curso:</strong>                
                    <div class="form-group">
                        <select id="lNivel" class="form-control" name="lNivel">
                            <option value="" disabled>-- Escoja el nivel --</option>
                            @foreach ($cboNiveles as $lista )
                                <option value="{{$lista->lValue_id}}" <?php if($lista->lValue_id == $grupos->lNivel): ?> selected <?php else: ?> disabled <?php endif; ?>>{{$lista->sParametro}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Grupo Paralelo:</strong>
                    <input type="text" class="form-control" name="sGrupo" value="{{$grupos->sGrupo}}">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Cantidad Minima:</strong>
                    <input type="number" value="{{$grupos->lMinimo}}" class="form-control" name="lMinimo">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Cantidad Máxima:</strong>
                    <input type="number" value="{{$grupos->lMaximo}}" class="form-control" name="lMaximo">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Inscritos al grupo:</strong>
                    <input readonly="True" type="text" name="lActual" value="{{ $grupos->lActual }}" class="form-control">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Estado del curso:</strong>                
                    <div class="form-group">
                        <select id="boolEstado" class="form-control" name="boolEstado">
                            <option value="" disabled>-- Escoja el Estado --</option>
                            @foreach ($cboEstados as $lista )
                                <option value="{{$lista->lValue_id}}" <?php if($lista->lValue_id == $grupos->boolEstado): ?> selected <?php else: ?> disabled <?php endif; ?>>{{$lista->sParametro}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>
        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
              <button type="submit" class="btn btn-primary">Enviar</button>
            </div>
        </div>
    </form>
@endsection