@extends('adminlte::page')

@section('content')
    <h1>Crear Grupos</h1><hr> 
    <!-- Formulario para crear un nuevo Grupos aquí -->
    <div class="row">
        <div class="col-lg-12 margin-tb">        
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('grupos.index') }}"> Volver</a>
            </div>
        </div>
    </div> 
    @if ($errors->any())
    <div class="alert alert-danger">
        <strong>Falla!!</strong> Tenemos problemas al insertar datos.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <form action="{{ route('grupos.store') }}" method="POST">
    @csrf
     <div class="row">        
        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Gestión:</strong>                
                <div class="form-group">
                    <select id="lGestion_id" class="form-control" name="lGestion_id">
                        <option value="">-- Escoja la gestión --</option>
                        @foreach ($cboGestiones as $lista )
                            <option value="{{$lista->lGestion_id}}" <?php if ($lista->lGestion_id == (int)session('GestionID')) : ?> selected <?php else : ?> disabled <?php endif; ?>>{{$lista->sGestion}}</option>                            
                        @endforeach                        
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Unidad Educativa:</strong>                
                <div class="form-group">
                    <select id="lUNegocio_id" class="form-control" name="lUNegocio_id">
                        <option value="">-- Escoja la unidad educativa --</option>
                        @foreach ($cboUNegocios as $lista )
                            <option value="{{$lista->lUNegocio_id}}" <?php if ($lista->lUNegocio_id == (int)session('UNegocioID')) : $lnivel = $lista->lNivel ?> selected <?php else : ?> disabled <?php endif; ?>>{{$lista->sDescripcion }}</option>                            
                        @endforeach                        
                    </select>
                </div>
            </div>
        </div><div class="col-xs-4 col-sm-4 col-md-4">
            <div class="form-group">
                <strong>Nivel del curso:</strong>                
                <div class="form-group">
                    <select id="lNivel" class="form-control" name="lNivel">
                        <option value="">-- Escoja el nivel --</option>
                        @foreach ($combobox as $lista )
                            <option value="{{$lista->lValue_id}}" <?php if ($lista->lValue_id == $lnivel): ?> selected <?php else : ?> disabled <?php endif; ?>>{{$lista->sParametro}}</option>    
                        @endforeach                        
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Curso:</strong>                
                <div class="form-group">
                    <select id="lCurso_id" class="form-control" name="lCurso_id">
                        <option value="">-- Escoja el curso --</option>
                        @foreach ($cboCursos as $lista )
                            <option value="{{$lista->lCurso_id}}">{{$lista->sCurso}}</option>    
                        @endforeach                        
                    </select>
                </div>
            </div>
        </div>        
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Grupo Paralelo:</strong>
                <input type="text" class="form-control" name="sGrupo" placeholder="Paralelo del grupo">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Cantidad Minima:</strong>
                <input type="number" value="15" class="form-control" name="lMinimo" placeholder="Cantidad minima">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Cantidad Máxima:</strong>
                <input type="number" value="40" class="form-control" name="lMaximo" placeholder="Cantidad Máximo">
            </div>
        </div>        
        
        
        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                <button type="submit" class="btn btn-primary">Enviar</button>
        </div>
    </div>
</form>
@endsection