@extends('adminlte::page')
@section('content')
    <h1>Show Gestión</h1>
    <div class="row">
        <div class="col-lg-12 margin-tb">            
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('gestiones.index') }}"> Back</a>
            </div>
        </div>
    </div>  

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Gestión:</strong>                
                {{ $gestion['sGestion'] }}
                {{ $gestion->boolEstado }}
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Fecha Inicio:</strong>
                {{ date("d/m/Y", strtotime($gestion->dtInicio)) }}
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Fecha Final:</strong>
                {{ date("d/m/Y", strtotime($gestion->dtFinal)) }}
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Meses:</strong>
                {{ $gestion->lMeses }}
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Descripcion:</strong>
                {{ $gestion->sDescripcion }}
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Gestión :</strong>                
                <?php if($gestion->boolEstado==1): ?> 
                    <strong>Abierta!!</strong>
                <?php else: ?>
                    <strong>Cerrada!!</strong>
                <?php endif; ?>
                
            </div>
        </div>
    </div>

@endsection