@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Gestiones.</h1>
<hr>
<!-- Mostrar la lista de gestiones aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('gestiones.create') }}"> Nueva Gestión</a>
        </div>
    </div>
</div>

@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
<!--<div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>-->
@endif

<table class="table table-hover table-sm">
    <thead class="table-dark">
        <tr>
            <th width="50px">Nro.</th>
            <th width="80px">Gestión</th>
            <th width="80px">Inicio</th>
            <th width="80px">Fin</th>
            <th width="50px">Meses</th>
            <th width="100px">Descripcion</th>
            <th width="180px">Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($gestiones as $gestion)
        <tr>
            <td>{{ $gestion->lGestion_id }}</td>
            <td>{{ $gestion->sGestion }}</td>
            <td>{{ date("d/m/Y", strtotime($gestion->dtInicio)) }}</td>
            <td>{{ date("d/m/Y", strtotime($gestion->dtFinal)) }}</td>
            <td>{{ $gestion->lMeses }}</td>
            <td>{{ $gestion->sDescripcion }}</td>
            <td>
                <?php if ($gestion->boolEstado == 1) : ?>
                    <form action="{{ route('gestiones.destroy',$gestion->lGestion_id) }}" method="POST">
                        <a class="btn btn-info" href="{{ route('gestiones.show',encrypt($gestion->lGestion_id)) }}">Show</a>
                        <a class="btn btn-primary" href="{{ route('gestiones.edit',encrypt($gestion->lGestion_id)) }}">Editar</a>
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>Gestión Cerrada!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>


<!--
        <div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4>Gestiones</h4>
                    <div class="text-end">
                        @include('buttons.previous', ['route' => url()->previous()])
                        @include('buttons.new', ['route' => route('gestiones.create')])
                    </div>
                </div>
                <div class="card-body">
                    <person-list
                        route_list="{{ url('gestiones/show/vue-list') }}"
                        route_delete="{{ url('people') }}"
                        route_edit="{{ url('gestiones/{id}/edit') }}"
                        route_show="{{ url('gestiones/{id}') }}">
					</person-list>
                    </div>
                </div>
            </div>
        </div>
    </div>-->

@endsection