@extends('adminlte::page')

@section('content')
    <h1>Editar Gestión</h1>
    <div class="row">
        <div class="col-lg-12 margin-tb">            
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('gestiones.index') }}"> Volver</a>
            </div>
        </div>
    </div>  

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Fallo!!</strong> Tenemos un problema en este momento.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif 

    <form action="{{ route('gestiones.update','gestion') }}" method="POST">
        @csrf
        @method('put')
         <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Gestión ID:</strong>
                    <input readonly="True" type="text" name="lGestion_id" value="{{ $gestion->lGestion_id }}" class="form-control" placeholder="Gestion ID">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Gestión:</strong>
                    <input type="text" name="sGestion" value="{{ $gestion->sGestion }}" class="form-control" placeholder="Gestión">
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Fecha Inicio:</strong>                    
                    <input type="date" name="dtInicio" class="form-control" placeholder="Fecha inicio" value="{{ $gestion->dtInicio }}">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Fecha final:</strong>
                    <input type="date" name="dtFinal" class="form-control" placeholder="Fecha final" value="{{ $gestion->dtFinal }}" >
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Meses:</strong>
                    <input type="number" name="lMeses" class="form-control" placeholder="Numero de meses" value="{{ $gestion->lMeses }}">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Estado:</strong>
                   <!-- <input type="number" name="boolEstado" class="form-control" placeholder="Estado" value="{{ $gestion->boolEstado }}"> -->
                    <input type="checkbox"  name="boolEstado" <?php if($gestion->boolEstado==1): ?> checked <?php else: ?> unchecked <?php endif; ?> />
                        <label> Activo?</label>
                    
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Descripción:</strong>
                    <textarea class="form-control" style="height:80px" name="sDescripcion" placeholder="Descripcion">{{ $gestion->sDescripcion }}</textarea>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
              <button type="submit" class="btn btn-primary">Enviar</button>
            </div>
        </div>
    </form>
@endsection