@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Detalles de Conceptos</h1>
<hr>
<!-- Mostrar la lista de detalles de conceptos aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('dconceptos.create') }}"> Nuevo Registro</a>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
@endif
<div class="table-responsive-sm">
    <table class="table table-hover table-sm">
        <thead class="table-dark">
            <tr>
                <th width="50px">Nro.</th>
                <th width="80px">Tipo Cobro</th>
                <th width="80px">Concepto</th>
                <th width="80px">Monto</th>
                <th width="80px">Gestion</th>
                <th width="80px">Unidad Educativa</th>
                <th width="180px">Action</th>
            </tr>
        </thead>
        @foreach ($dconceptos as $dconcepto)
        <tbody>
            <tr>
                <td>{{ $dconcepto->lDConcepto_id }}</td>
                <td>{{ $dconcepto->sParametro }}</td>
                <td>{{ $dconcepto->sConcepto }}</td>
                <td>{{ $dconcepto->lMonto }}</td>
                <td>{{ $dconcepto->sGestion }}</td>
                <td>{{ $dconcepto->sUNegocio }}</td>

                <td>
                    <form action="{{ route('dconceptos.destroy',$dconcepto->lDConcepto_id) }}" method="POST">
                        <a class="btn btn-info" href="{{ route('dconceptos.show',encrypt($dconcepto->lDConcepto_id)) }}">Show</a>
                        <a class="btn btn-primary" href="{{ route('dconceptos.edit', encrypt($dconcepto->lDConcepto_id)) }}">Editar</a>
                        @method('PUT')
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                </td>
            </tr>
        </tbody>
        @endforeach
    </table>
</div>
@endsection