@extends('adminlte::page')

@section('content')
    <h1>Editar Cobros</h1><hr>
    <!-- Formulario para editar detalle de concepto aquí -->
    <div class="row">
        <div class="col-lg-12 margin-tb">            
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('dconceptos.index') }}"> Volver</a>
            </div>
        </div>
    </div>  

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Fallo!!</strong> Tenemos un problema en este momento.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif 

    <form action="{{ route('dconceptos.update','dconceptos') }}" method="POST">
        @csrf
        @method('put')
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Cobro ID:</strong>
                    <input readonly="True" type="text" name="lDConcepto_id" value="{{ $dconceptos->lDConcepto_id }}" class="form-control">
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Gestión Academica:</strong>                
                <div class="form-group">
                    <select id="lGestion_id" class="form-control" name="lGestion_id">
                        <option value="" disabled>-- Escoja Gestión --</option>
                        @foreach ($cboGestiones as $lista )                            
                            <option value="{{$lista->lGestion_id}}" <?php if($lista->lGestion_id == $dconceptos->lGestion_id): ?> selected 
                                                                     <?php else: ?> disabled <?php endif;?> >{{$lista->sGestion}} </option>    
                        @endforeach                        
                    </select>
                </div>
            </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Unidad Educativa:</strong>                
                    <div class="form-group">
                        <select id="lUNegocio_id" class="form-control" name="lUNegocio_id">
                            <option value="" disabled>-- Escoja Unidad Educativa --</option>
                            @foreach ($cboUNegocios as $lista )
                                <option value="{{$lista->lUNegocio_id}}" <?php if($lista->lUNegocio_id == $dconceptos->lUNegocio_id): ?> selected
                                        <?php else:?> disabled <?php endif;?> >{{$lista->sDescripcion}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Concepto del cobro:</strong>                
                    <div class="form-group">
                        <select id="lConcepto_id" class="form-control" name="lConcepto_id">
                            <option value="0" disabled>-- Escoja el concepto --</option>
                            @foreach ($cboConceptos as $lista )
                                <option value="{{$lista->lConcepto_id}}" <?php if($lista->lConcepto_id == $dconceptos->lConcepto_id): ?> selected
                                        <?php else:?> ' ' <?php endif;?> >{{$lista->sConcepto .' ('. $lista->sParametro.')'}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Tipo Pago:</strong>                
                    <div class="form-group">
                        <select id="lTipoDConcepto" class="form-control" name="lTipoDConcepto" onchange="comprobar();">
                            <option value="" disabled>-- Escoja tipo Pago --</option>
                            @foreach ($cboTipoDConceptos as $lista )
                                <option value="{{$lista->lValue_id}}" <?php if($lista->lValue_id == $dconceptos->lTipoDConcepto): ?> selected
                                        <?php else:?> ' ' <?php endif;?> >{{$lista->sParametro}}</option>    
                            @endforeach                        
                        </select>
                    </div>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Monto del cobro:</strong>
                    <input type="number" readonly= {{$dconceptos->lTipoDConcepto==2? true:false}} required id="lMonto" value="{{$dconceptos->lMonto}}" class="form-control" name="lMonto">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                    <button type="submit" class="btn btn-primary">Enviar</button>
            </div>
            
        </div>
    </form>
    <script type="text/javascript">
        function comprobar()
        {   
            var select = document.getElementById('lTipoDConcepto').value; //value para el ID .text para el texto
            //alert(select);
            if (select==2) //Variable puede ser otros montos 
                document.getElementById('lMonto').value=0;
            document.getElementById('lMonto').readOnly = (select==2? true:false);
        }
    </script>
@endsection