@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Cursos</h1>
<!-- Mostrar la lista de cursos aquí -->
<hr>

<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('cursos.create') }}"> Nuevo Curso</a>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
<!--<div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>-->
@endif
<table class="table table-hover table-sm">
    <thead class="table-dark">
        <th width="50px">Nro.</th>
        <th width="80px">Curso</th>
        <th width="80px">Descripción</th>
        <th width="180px">Action</th>
    </thead>
    <tbody>
        @foreach ($cursos as $curso)
        <tr>
            <td>{{ $curso->lCurso_id }}</td>
            <td>{{ $curso->sCurso }}</td>
            <td>{{ $curso->sDescripcion }}</td>

            <td>
                <form action="{{ route('cursos.destroy', encrypt($curso->lCurso_id)) }}" method="POST">
                    <a class="btn btn-info" href="{{ route('cursos.show',encrypt($curso->lCurso_id)) }}">Show</a>
                    <a class="fa fa-edit btn btn-primary" href="{{ route('cursos.edit', encrypt($curso->lCurso_id)) }}">Editar</a>
                    @method('PUT')
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Cerrar</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection