@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
    <h1>Editar Cursos</h1><hr>
    <!-- Mostrar la lista de Cursos aquí -->
    <div class="row">
        <div class="col-lg-12 margin-tb">            
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('cursos.index') }}"> Volver</a>
            </div>
        </div>
    </div>  

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Fallo!!</strong> Tenemos un problema en este momento.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif 
    <form action="{{ route('cursos.update','cursos') }}" method="POST">
        @csrf
        @method('put')
         <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Curso ID:</strong>
                    <input readonly="True" type="text" name="lCurso_id" value="{{ $curso->lCurso_id }}" class="form-control">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Curso:</strong>
                    <input type="text" name="sCurso" value="{{ $curso->sCurso }}" class="form-control">
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Descripción del curso:</strong>
                    <input type="text" name="sDescripcion" value="{{ $curso->sDescripcion }}" class="form-control">
                </div>
            </div>            

            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
              <button type="submit" class="btn btn-primary">Enviar</button>
            </div>
        </div>
    </form>
@endsection