@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<h1>Listado de Conceptos</h1>
<hr>
<!-- Mostrar la lista de conceptos aquí -->
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <a class="btn btn-success" href="{{ route('conceptos.create') }}"> Nuevo Concepto</a>
        </div>
    </div>
</div>
@if ($message = Session::get('success'))
<script>
    Swal.fire('Operación', '{{ $message }}', 'success')
</script>
@endif

<table class="table table-hover table-sm">
    <thead class="table-dark">
        <tr>
            <th width="50px">Nro.</th>
            <th width="80px">Concepto</th>
            <th width="80px">Tipo</th>
            <th width="80px">Estado</th>
            <th width="180px">Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($conceptos as $concepto)
        <tr>
            <td>{{ $concepto->lConcepto_id }}</td>
            <td>{{ $concepto->sConcepto }}</td>
            <td>{{ $concepto->sParametro }}</td>
            <td><?php if ($concepto->boolEstado == 1) : ?>
                    <strong>Activa</strong>
                <?php else : ?>
                    <strong>No ACTIVA!!</strong>
                <?php endif ?>
            </td>
            <td>
                <?php if ($concepto->boolEstado == 1) : ?>
                    <form action="{{ route('conceptos.destroy',$concepto->lConcepto_id) }}" method="POST">
                        <a class="btn btn-info" href="{{ route('conceptos.show',encrypt($concepto->lConcepto_id)) }}">Show</a>
                        <a class="btn btn-primary" href="{{ route('conceptos.edit', encrypt($concepto->lConcepto_id)) }}">Editar</a>
                        @method('PUT')
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Cerrar</button>
                    </form>
                <?php else : ?>
                    <strong>No activo!!</strong>
                <?php endif; ?>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection