@extends('adminlte::page')
@section('title', 'App-Pagos')

@section('content')
    <h1>Editar Conceptos</h1>
    <!-- Mostrar la lista de conceptos aquí -->
    <div class="row">
        <div class="col-lg-12 margin-tb">            
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('conceptos.index') }}"> Volver</a>
            </div>
        </div>
    </div>  

    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>Fallo!!</strong> Tenemos un problema en este momento.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif 
    <form action="{{ route('conceptos.update','conceptos') }}" method="POST">
        @csrf
        @method('put')
         <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Concepto ID:</strong>
                    <input readonly="True" type="text" name="lConcepto_id" value="{{ $concepto->lConcepto_id }}" class="form-control">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Concepto:</strong>
                    <input type="text" name="sConcepto" value="{{ $concepto->sConcepto }}" class="form-control">
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Tipo Concepto:</strong>
                    <!--<input type="text" name="lTipoConcepto" value="{{ $concepto->lTipoConcepto }}" class="form-control" >-->
                    <select id="lTipoConcepto" class="form-control" name="lTipoConcepto" >
                        <option value="" disabled>-- Escoja el grupo --</option>
                        @foreach ($combobox as $lista )
                            <option value="{{$lista->lValue_id}}" <?php if($lista->lValue_id == $concepto->lTipoConcepto): ?> selected <?php else: ?> ' ' <?php endif; ?> >{{$lista->sParametro}} </option>    
                        @endforeach                        
                    </select>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="form-group">
                    <strong>Activo..? </strong>                    
                    <input type="checkbox" name="boolEstado" <?php if($concepto->boolEstado==1): ?> checked <?php else: ?> unchecked <?php endif; ?> />
                </div>
            </div>
            
            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
              <button type="submit" class="btn btn-primary">Enviar</button>
            </div>
        </div>
    </form>
@endsection