@extends('adminlte::page')

@section('content')
    <h1>Crear Concepto</h1><hr> 
    <!-- Formulario para crear un nuevo concepto aquí -->
    <div class="row">
        <div class="col-lg-12 margin-tb">        
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('conceptos.index') }}"> Volver</a>
            </div>
        </div>
    </div> 
    @if ($errors->any())
    <div class="alert alert-danger">
        <strong>Falla!!</strong> Tenemos problemas al insertar datos.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <form action="{{ route('conceptos.store') }}" method="POST">
    @csrf
     <div class="row">        
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Descripción:</strong>
                <input type="text" class="form-control" name="sConcepto" placeholder="Descripción de conceptos">
            </div>
        </div>
        
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Tipo Concepto:</strong>
                
                <div class="form-group">
                    <select id="lTipoConcepto" class="form-control" name="lTipoConcepto">
                        <option value="">-- Escoja el grupo --</option>
                        @foreach ($combobox as $lista )
                            <option value="{{$lista->lValue_id}}">{{$lista->sParametro}}</option>    
                        @endforeach                        
                    </select>
                </div>
            </div>
        </div>
        
        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                <button type="submit" class="btn btn-primary">Enviar</button>
        </div>
    </div>
</form>
@endsection