<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblGruposTable extends Migration
{
    public function up()
    {
        Schema::create('tblGrupos', function (Blueprint $table) {
            $table->id('lGrupo_id');
            $table->string('sGrupo', 10);
            $table->integer('lGestion_id')->nullable();
            $table->tinyInteger('lMinimo')->default(15);
            $table->tinyInteger('lMaximo')->default(30);
            $table->tinyInteger('lActual')->default(0);
            $table->unsignedBigInteger('lCurso_id');
            $table->tinyInteger('boolEstado')->default(1);
            $table->unsignedBigInteger('lUNegocio_id');
            $table->tinyInteger('lNivel'); 
            $table->timestamps();
            $table->foreign('lCurso_id')->references('lCurso_id')->on('tblCursos');
            $table->foreign('lUNegocio_id')->references('lUNegocio_id')->on('tblUNegocios');
        });
    }

    public function down()
    {
        Schema::dropIfExists('tblGrupos');
    }
};
