<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbldtransacciones', function (Blueprint $table) {
            $table->id('lDTransaccion_id');
            $table->decimal('lMonto', 6, 2)->nullable();
            $table->smallInteger('lCantidad')->nullable();
            $table->decimal('lSubTotal', 6, 2)->nullable();
            $table->unsignedBigInteger('lTransaccion_id');
            $table->unsignedBigInteger('lDConcepto_id');
            $table->timestamps();

            $table->foreign('lTransaccion_id')->references('lTransaccion_id')->on('tblTransacciones');
            $table->foreign('lDConcepto_id')->references('lDConcepto_id')->on('tblDConceptos');        
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbldtransacciones');
    }
};
