<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbldconceptos', function (Blueprint $table) {
            $table->id('lDConcepto_id');
            $table->decimal('lMonto', 6, 2)->nullable();
            $table->tinyInteger('lTipoDConcepto');
            $table->unsignedBigInteger('lGestion_id');
            $table->unsignedBigInteger('lConcepto_id');
            $table->unsignedBigInteger('lUNegocio_id');
            $table->timestamps();

            $table->foreign('lGestion_id')->references('lGestion_id')->on('tblGestiones');
            $table->foreign('lConcepto_id')->references('lConcepto_id')->on('tblConceptos');
            $table->foreign('lUNegocio_id')->references('lUNegocio_id')->on('tblUNegocios');        
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbldconceptos');
    }
};
