<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tblgestiones', function (Blueprint $table) {
            $table->id('lGestion_id');
            $table->string('sGestion', 50)->unique();
            $table->date('dtInicio')->nullable();
            $table->date('dtFinal')->nullable();
            $table->tinyInteger('boolEstado')->default(1);
            $table->tinyInteger('lMeses')->default(10);
            $table->string('sDescripcion', 200)->nullable();            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tblgestiones');
    }
};
