<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbltransacciones', function (Blueprint $table) {
            $table->id('lTransaccion_id');
            $table->smallInteger('lNroTransaccion')->nullable();
            $table->date('dtTransaccion')->nullable();
            $table->tinyInteger('lTipo');
            $table->string('sCliente', 200)->nullable();
            $table->decimal('lTotal', 6, 2)->default(0);
            $table->tinyInteger('lEstado');
            $table->unsignedBigInteger('lRegistro_id');
            $table->unsignedBigInteger('lGestion_id');
            $table->unsignedBigInteger('lUNegocio_id');
            $table->string('sGlosa', 200)->nullable();
            $table->timestamps();

            $table->foreign('lRegistro_id')->references('lRegistro_id')->on('tblRegistros');        
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbltransacciones');
    }
};
