<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tblplanpagos', function (Blueprint $table) {
            $table->id('lPlanPago_id');
            $table->smallInteger('lNroCuota')->nullable();
            $table->decimal('lMonto', 6, 2)->default(0);
            $table->date('dtVencimiento')->nullable();
            $table->tinyInteger('lEstado');
            $table->decimal('lSaldo', 6, 2)->default(0);
            $table->unsignedBigInteger('lRegistro_id');
            $table->date('dtPagado')->nullable();
            $table->timestamps();
            $table->foreign('lRegistro_id')->references('lRegistro_id')->on('tblRegistros');        
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tblplanpagos');
    }
};
